/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.BaseScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class FilterScopeProcessor<T>
extends BaseScopeProcessor {
    protected final List<T> myResults;
    private PsiElement myCurrentDeclarationHolder;
    private final ElementFilter myFilter;
    private final PsiScopeProcessor myProcessor;

    public FilterScopeProcessor(ElementFilter filter, List<T> container) {
        this(filter, null, container);
    }

    public FilterScopeProcessor(ElementFilter filter, PsiScopeProcessor processor) {
        this(filter, processor, new SmartList());
    }

    public FilterScopeProcessor(ElementFilter filter) {
        this(filter, null, new SmartList());
    }

    public FilterScopeProcessor(ElementFilter filter, @Nullable PsiScopeProcessor processor, List<T> container) {
        this.myFilter = filter;
        this.myProcessor = processor;
        this.myResults = container;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (this.myProcessor != null) {
            this.myProcessor.handleEvent(event, associated);
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER && associated instanceof PsiElement) {
            this.myCurrentDeclarationHolder = (PsiElement)associated;
        }
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (this.myFilter.isAcceptable(element, this.myCurrentDeclarationHolder)) {
            if (this.myProcessor != null) {
                return this.myProcessor.execute(element, state);
            }
            this.add(element, state.get(PsiSubstitutor.KEY));
        }
        return true;
    }

    protected void add(PsiElement element, PsiSubstitutor substitutor) {
        this.myResults.add(element);
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (this.myProcessor != null) {
            return this.myProcessor.getHint(hintKey);
        }
        return null;
    }

    public List<T> getResults() {
        return this.myResults;
    }
}

