/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.jet.internal.com.intellij.psi.scope.NameHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult = null;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name, ElementFilter filter, PsiConflictResolver[] resolvers, List<CandidateInfo> container, PsiElement place) {
        super(filter, container);
        this.myResolvers = resolvers;
        this.myName = name;
        this.myPlace = place;
        this.myPlaceFile = place.getContainingFile();
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (this.myCachedResult != null && this.myCachedResult.length == 1 && this.myCachedResult[0].isAccessible()) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace)) {
            return super.execute(element, state);
        }
        return true;
    }

    @Override
    protected void add(PsiElement element, PsiSubstitutor substitutor) {
        this.add(new CandidateInfo(element, substitutor));
    }

    protected void add(CandidateInfo info) {
        this.myCachedResult = null;
        this.myResults.add(info);
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    public JavaResolveResult[] getResult() {
        if (this.myCachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            for (PsiConflictResolver resolver : this.myResolvers) {
                CandidateInfo candidate = resolver.resolveConflict(conflicts);
                if (candidate == null) continue;
                conflicts.clear();
                conflicts.add(candidate);
                break;
            }
            this.myCachedResult = conflicts.toArray(new JavaResolveResult[conflicts.size()]);
        }
        return this.myCachedResult;
    }

    @Override
    public String getName(ResolveState state) {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }
}

