/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.scope.conflictResolvers;

import java.util.List;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;

public class DuplicateConflictResolver
implements PsiConflictResolver {
    public static final DuplicateConflictResolver INSTANCE = new DuplicateConflictResolver();

    private DuplicateConflictResolver() {
    }

    @Override
    public CandidateInfo resolveConflict(List<CandidateInfo> conflicts) {
        HashMap<Object, CandidateInfo> uniqueItems = new HashMap<Object, CandidateInfo>();
        for (CandidateInfo info : conflicts) {
            PsiElement element = info.getElement();
            Object key = element instanceof PsiMethod ? ((PsiMethod)element).getSignature(info.getSubstitutor()) : PsiUtilCore.getName(element);
            if (uniqueItems.containsKey(key)) continue;
            uniqueItems.put(key, info);
        }
        if (uniqueItems.size() == 1) {
            return (CandidateInfo)uniqueItems.values().iterator().next();
        }
        return null;
    }
}

