/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiTypeCastExpressionImpl
extends ExpressionPsiElement
implements PsiTypeCastExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiTypeCastExpressionImpl");

    public PsiTypeCastExpressionImpl() {
        super(TYPE_CAST_EXPRESSION);
    }

    @Override
    public PsiTypeElement getCastType() {
        return (PsiTypeElement)this.findChildByRoleAsPsiElement(10);
    }

    @Override
    public PsiExpression getOperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(67);
    }

    @Override
    @Nullable
    public PsiType getType() {
        PsiTypeElement castType = this.getCastType();
        if (castType == null) {
            return null;
        }
        return castType.getType();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 67: 
        }
        return this.findChildByType(EXPRESSION_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this) : "child:" + child + "; child.getTreeParent():" + child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == TYPE) {
            return 10;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiTypeCastExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeCastExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiTypeCastExpression:" + this.getText();
    }
}

