/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiThrowStatementImpl
extends CompositePsiElement
implements PsiThrowStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiThrowStatementImpl");

    public PsiThrowStatementImpl() {
        super(THROW_STATEMENT);
    }

    @Override
    public PsiExpression getException() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(58);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 57: {
                return this.findChildByType(THROW_KEYWORD);
            }
            case 58: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == THROW_KEYWORD) {
            return 57;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 58;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiThrowStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitThrowStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiThrowStatement";
    }
}

