/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiThisExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiThisExpressionImpl
extends ExpressionPsiElement
implements PsiThisExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiThisExpressionImpl");

    public PsiThisExpressionImpl() {
        super(THIS_EXPRESSION);
    }

    @Override
    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiClass qualifierResolve = (PsiClass)qualifier.resolve();
            if (qualifierResolve != null) {
                return new PsiImmediateClassType(qualifierResolve, PsiSubstitutor.EMPTY);
            }
            return new PsiClassReferenceType(qualifier, null);
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentThisType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentThisType = ((JavaCodeFragment)scope).getThisType()) == null) continue;
            return fragmentThisType;
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 95: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == THIS_KEYWORD) {
            return 95;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiThisExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitThisExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiThisExpression:" + this.getText();
    }
}

