/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSwitchLabelStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiSwitchLabelStatementImpl
extends CompositePsiElement
implements PsiSwitchLabelStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSwitchLabelStatementImpl");

    public PsiSwitchLabelStatementImpl() {
        super(SWITCH_LABEL_STATEMENT);
    }

    @Override
    public boolean isDefaultCase() {
        return this.findChildByRoleAsPsiElement(85) != null;
    }

    @Override
    public PsiExpression getCaseValue() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(86);
    }

    @Override
    public PsiSwitchStatement getEnclosingSwitchStatement() {
        CompositeElement guessedSwitch = this.getTreeParent().getTreeParent();
        return guessedSwitch != null && guessedSwitch.getElementType() == SWITCH_STATEMENT ? (PsiSwitchStatement)SourceTreeToPsiMap.treeElementToPsi(guessedSwitch) : null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 84: {
                return this.findChildByType(CASE_KEYWORD);
            }
            case 85: {
                return this.findChildByType(DEFAULT_KEYWORD);
            }
            case 86: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 87: 
        }
        return this.findChildByType(COLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == CASE_KEYWORD) {
            return 84;
        }
        if (i == DEFAULT_KEYWORD) {
            return 85;
        }
        if (i == COLON) {
            return 87;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 86;
        }
        return 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass aClass;
        PsiExpression expression;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl.processDeclarations must not be null");
        }
        if (lastParent == null) {
            return true;
        }
        PsiSwitchStatement switchStatement = this.getEnclosingSwitchStatement();
        if (switchStatement != null && (expression = switchStatement.getExpression()) != null && expression.getType() instanceof PsiClassType && (aClass = ((PsiClassType)expression.getType()).resolve()) != null) {
            aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.ENUM_CONST, processor), state, this, place);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSwitchLabelStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSwitchLabelStatement";
    }
}

