/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiSuperExpressionImpl
extends ExpressionPsiElement
implements PsiSuperExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSuperExpressionImpl");

    public PsiSuperExpressionImpl() {
        super(SUPER_EXPRESSION);
    }

    @Override
    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiElement aClass = qualifier.resolve();
            return aClass instanceof PsiClass ? this.getSuperType((PsiClass)aClass) : null;
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentSuperType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return this.getSuperType(aClass);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentSuperType = ((JavaCodeFragment)scope).getSuperType()) == null) continue;
            return fragmentSuperType;
        }
        return null;
    }

    private PsiType getSuperType(PsiClass aClass) {
        if (aClass.isInterface()) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
            return facade.getElementFactory().createType(facade.findClass("java.lang.Object", this.getResolveScope()));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClass psiClass = baseClassType.resolve();
            if (psiClass != null && !psiClass.isInterface()) {
                return baseClassType;
            }
            return PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] superTypes = aClass.getExtendsListTypes();
        if (superTypes.length == 0) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
            PsiClass javaLangObject = facade.findClass("java.lang.Object", this.getResolveScope());
            if (javaLangObject != null) {
                return facade.getElementFactory().createType(javaLangObject);
            }
            return null;
        }
        return superTypes[0];
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 96: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == SUPER_KEYWORD) {
            return 96;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiSuperExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSuperExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSuperExpression:" + this.getText();
    }
}

