/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMember;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNamedElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTarget;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.jet.internal.com.intellij.psi.filters.AndFilter;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ConstructorFilter;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.filters.NotFilter;
import org.jetbrains.jet.internal.com.intellij.psi.filters.OrFilter;
import org.jetbrains.jet.internal.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceJavaCodeReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SourceUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.NullableFunction;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class PsiReferenceExpressionImpl
extends ExpressionPsiElement
implements PsiReferenceExpression,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl");
    private volatile String myCachedQName = null;
    private volatile String myCachedTextSkipWhiteSpaceAndComments = null;
    private final Function<PsiReferenceExpressionImpl, PsiType> ourTypeEvaluator = new TypeEvaluator();

    public PsiReferenceExpressionImpl() {
        super(JavaElementType.REFERENCE_EXPRESSION);
    }

    @Override
    public PsiExpression getQualifierExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        boolean doImportStatic;
        if (qualifierClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.bindToElementViaStaticImport must not be null");
        }
        String qualifiedName = qualifierClass.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException();
        }
        if (this.getQualifierExpression() != null) {
            throw new IncorrectOperationException("Reference is qualified: " + this.getText());
        }
        if (!this.isPhysical()) {
            return this;
        }
        String staticName = this.getReferenceName();
        PsiFile containingFile = this.getContainingFile();
        PsiImportList importList = null;
        if (containingFile instanceof PsiJavaFile) {
            String qName;
            importList = ((PsiJavaFile)containingFile).getImportList();
            PsiImportStatementBase singleImportStatement = importList.findSingleImportStatement(staticName);
            boolean bl = doImportStatic = singleImportStatement == null;
            if (singleImportStatement instanceof PsiImportStaticStatement && (qName = qualifierClass.getQualifiedName() + "." + staticName).equals(singleImportStatement.getImportReference().getQualifiedName())) {
                return this;
            }
        } else {
            doImportStatic = false;
        }
        if (doImportStatic) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(qualifierClass, staticName, importList);
        } else {
            PsiManager manager = this.getManager();
            PsiReferenceExpression classRef = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createReferenceExpression(qualifierClass);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, manager);
            this.addInternal(dot, dot, SourceTreeToPsiMap.psiElementToTree(this.getParameterList()), Boolean.TRUE);
            this.addBefore(classRef, SourceTreeToPsiMap.treeElementToPsi(dot));
        }
        return this;
    }

    public static void bindToElementViaStaticImport(PsiClass qualifierClass, String staticName, PsiImportList importList) throws IncorrectOperationException {
        String qualifiedName = qualifierClass.getQualifiedName();
        List<PsiJavaCodeReferenceElement> refs = PsiReferenceExpressionImpl.getImportsFromClass(importList, qualifiedName);
        if (refs.size() < JavaCodeStyleSettingsFacade.getInstance(qualifierClass.getProject()).getNamesCountToUseImportOnDemand()) {
            importList.add(JavaPsiFacade.getInstance(qualifierClass.getProject()).getElementFactory().createImportStaticStatement(qualifierClass, staticName));
        } else {
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiImportStaticStatement importStatement = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStaticStatement.class);
                if (importStatement == null) continue;
                importStatement.delete();
            }
            importList.add(JavaPsiFacade.getInstance(qualifierClass.getProject()).getElementFactory().createImportStaticStatement(qualifierClass, "*"));
        }
    }

    private static List<PsiJavaCodeReferenceElement> getImportsFromClass(@NotNull PsiImportList importList, String className) {
        if (importList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getImportsFromClass must not be null");
        }
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !Comparing.strEqual(psiClass.getQualifiedName(), className)) continue;
            array.add(staticStatement.getImportReference());
        }
        return array;
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        PsiExpression oldQualifier = this.getQualifierExpression();
        if (newQualifier == null) {
            if (oldQualifier != null) {
                this.deleteChildInternal(oldQualifier.getNode());
            }
        } else if (oldQualifier != null) {
            oldQualifier.replace(newQualifier);
        } else {
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            TreeElement dot = (TreeElement)this.findChildByRole(55);
            if (dot == null) {
                dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, this.getManager());
                dot = this.addInternal(dot, dot, this.getFirstChildNode(), Boolean.TRUE);
            }
            this.addBefore(newQualifier, dot.getPsi());
        }
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public void clearCaches() {
        this.myCachedQName = null;
        this.myCachedTextSkipWhiteSpaceAndComments = null;
        super.clearCaches();
    }

    private JavaResolveResult[] resolve(IElementType parentType) {
        if (parentType == null) {
            IElementType iElementType = parentType = this.getTreeParent() != null ? this.getTreeParent().getElementType() : null;
        }
        if (parentType == JavaElementType.REFERENCE_EXPRESSION) {
            JavaResolveResult[] result = this.resolveToVariable();
            if (result.length > 0) {
                return result;
            }
            PsiElement classNameElement = this.getReferenceNameElement();
            if (!(classNameElement instanceof PsiIdentifier)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            result = this.resolveToClass(classNameElement);
            if (result.length > 0) {
                return result;
            }
            return this.resolveToPackage();
        }
        if (parentType == JavaElementType.METHOD_CALL_EXPRESSION) {
            return this.resolveToMethod();
        }
        return this.resolveToVariable();
    }

    private JavaResolveResult[] resolveToMethod() {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.getParent();
        MethodResolverProcessor processor = new MethodResolverProcessor(methodCall);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
        }
        catch (MethodProcessorSetupFailedException e) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return processor.getResult();
    }

    private JavaResolveResult[] resolveToPackage() {
        String packageName = this.getCachedTextSkipWhiteSpaceAndComments();
        PsiManager manager = this.getManager();
        PsiPackage aPackage = JavaPsiFacade.getInstance(manager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            return JavaPsiFacade.getInstance(manager.getProject()).isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
        }
        PsiExpression qualifier = this.getQualifierExpression();
        if (qualifier instanceof PsiReferenceExpression && !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiPackage)) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return new JavaResolveResult[]{new CandidateInfo(aPackage, PsiSubstitutor.EMPTY)};
    }

    private JavaResolveResult[] resolveToClass(PsiElement classNameElement) {
        String className = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className, this);
        PsiScopesUtil.resolveAndWalk(processor, this, null);
        return processor.getResult();
    }

    private JavaResolveResult[] resolveToVariable() {
        VariableResolverProcessor processor = new VariableResolverProcessor(this);
        PsiScopesUtil.resolveAndWalk(processor, this, null);
        return processor.getResult();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        PsiManager manager = this.getManager();
        if (manager == null) {
            LOG.error("getManager() == null!");
            javaResolveResultArray = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.multiResolve must not return null");
        } else {
            ResolveResult[] results = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, OurGenericsResolver.INSTANCE, true, incompleteCode);
            javaResolveResultArray = results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getCanonicalText() {
        String string;
        PsiElement element = this.resolve();
        if (element instanceof PsiClass && !(element instanceof PsiTypeParameter)) {
            String fqn = ((PsiClass)element).getQualifiedName();
            if (fqn != null) {
                string = fqn;
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getCanonicalText must not return null");
                return string;
            }
            LOG.error("FQN is null. Reference:" + this.getElement().getText() + " resolves to:" + LogUtil.objectAndClass(element) + " parent:" + LogUtil.objectAndClass(element.getParent()));
        }
        if ((string = this.getCachedTextSkipWhiteSpaceAndComments()) != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getCanonicalText must not return null");
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, this.ourTypeEvaluator);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        PsiElement parent;
        boolean parentIsMethodCall;
        IElementType i = this.getLastChildNode().getElementType();
        boolean resolvingToMethod = element instanceof PsiMethod;
        if (i == JavaTokenType.IDENTIFIER) {
            if (!(element instanceof PsiPackage)) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                String name = ((PsiNamedElement)element).getName();
                if (name == null) {
                    return false;
                }
                if (!name.equals(this.getLastChildNode().getText())) {
                    return false;
                }
            }
        } else if (i == JavaTokenType.SUPER_KEYWORD || i == JavaTokenType.THIS_KEYWORD) {
            if (!resolvingToMethod) {
                return false;
            }
            if (!((PsiMethod)element).isConstructor()) {
                return false;
            }
        }
        if ((parentIsMethodCall = (parent = this.getParent()) instanceof PsiMethodCallExpression) != resolvingToMethod) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        OrFilter filter = new OrFilter();
        filter.addFilter(ElementClassFilter.CLASS);
        if (this.isQualified()) {
            filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
        }
        filter.addFilter(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
        filter.addFilter(ElementClassFilter.VARIABLE);
        FilterScopeProcessor proc = new FilterScopeProcessor(filter, processor){
            private final Set<String> myVarNames;
            {
                this.myVarNames = new THashSet<String>();
            }

            @Override
            public boolean execute(PsiElement element, ResolveState state) {
                if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    this.myVarNames.add(((PsiVariable)element).getName());
                } else {
                    if (element instanceof PsiField && this.myVarNames.contains(((PsiVariable)element).getName())) {
                        return true;
                    }
                    if (element instanceof PsiClass && PsiReferenceExpressionImpl.seemsScrambled((PsiClass)element)) {
                        return true;
                    }
                }
                return super.execute(element, state);
            }
        };
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    private static boolean seemsScrambled(PsiClass element) {
        if (!(element instanceof PsiCompiledElement)) {
            return false;
        }
        String qualifiedName = element.getQualifiedName();
        return qualifiedName != null && qualifiedName.length() <= 2 && qualifiedName.length() > 0 && Character.isLowerCase(qualifiedName.charAt(0));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.advancedResolve must not return null");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        return refName == null ? super.getTextOffset() : refName.getStartOffset();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.getQualifierExpression() != null) {
            return this.renameDirectly(newElementName);
        }
        JavaResolveResult resolveResult = this.advancedResolve(false);
        if (resolveResult.getElement() == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
        if (!(currentFileResolveScope instanceof PsiImportStaticStatement) || ((PsiImportStaticStatement)currentFileResolveScope).isOnDemand()) {
            return this.renameDirectly(newElementName);
        }
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
        String referenceName = importStaticStatement.getReferenceName();
        LOG.assertTrue(referenceName != null);
        PsiElement element = importStaticStatement.getImportReference().resolve();
        if (this.getManager().areElementsEquivalent(element, resolveResult.getElement())) {
            return this.renameDirectly(newElementName);
        }
        PsiClass psiClass = importStaticStatement.resolveTargetClass();
        if (psiClass == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        PsiReferenceExpression expression = (PsiReferenceExpression)factory.createExpressionFromText("X." + newElementName, this);
        PsiReferenceExpression result = (PsiReferenceExpression)this.replace(expression);
        ((PsiReferenceExpression)result.getQualifierExpression()).bindToElement(psiClass);
        return result;
    }

    private PsiElement renameDirectly(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.bindToElement must not be null");
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        PsiManager manager = this.getManager();
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        if (element instanceof PsiClass) {
            boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance(this.getProject()).useFQClassNames() && PsiReferenceExpressionImpl.isFullyQualified(this);
            String qName = ((PsiClass)element).getQualifiedName();
            if (qName == null) {
                qName = ((PsiClass)element).getName();
            } else if (JavaPsiFacade.getInstance(manager.getProject()).findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                return this;
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(manager.getProject());
            if (!preserveQualification) {
                ref = (PsiExpression)codeStyleManager.shortenClassReferences(ref, 8192);
            }
            return ref;
        }
        if (element instanceof PsiPackage) {
            String qName = ((PsiPackage)element).getQualifiedName();
            if (qName.length() == 0) {
                throw new IncorrectOperationException();
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            return ref;
        }
        if ((element instanceof PsiField || element instanceof PsiMethod) && ((PsiMember)element).hasModifierProperty("static")) {
            if (!this.isPhysical()) {
                return this;
            }
            PsiMember member = (PsiMember)element;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            return ref;
        }
        throw new IncorrectOperationException(((Object)element).toString());
    }

    private static boolean isFullyQualified(CompositeElement classRef) {
        ASTNode qualifier = classRef.findChildByRole(54);
        if (qualifier == null) {
            return false;
        }
        if (qualifier.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
            return false;
        }
        PsiElement refElement = ((PsiReference)((Object)qualifier)).resolve();
        return refElement instanceof PsiPackage || PsiReferenceExpressionImpl.isFullyQualified((CompositeElement)qualifier);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.deleteChildInternal must not be null");
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            super.deleteChildInternal(child);
            this.deleteChildInternal(dot);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                if (this.getChildRole(this.getLastChildNode()) == role) {
                    return this.getLastChildNode();
                }
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                if (this.getChildRole(this.getFirstChildNode()) == 54) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.IDENTIFIER || i == JavaTokenType.THIS_KEYWORD || i == JavaTokenType.SUPER_KEYWORD) {
            return 53;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 54;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            TreeElement dot = (TreeElement)this.findChildByRole(55);
            if (dot == null) {
                LOG.error(this.toString());
            }
            return new TextRange(dot.getStartOffsetInParent() + dot.getTextLength(), this.getTextLength());
        }
        return new TextRange(nameChild.getStartOffsetInParent(), this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray;
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getTypeParameters must not return null");
            return psiTypeArray;
        }
        psiTypeArray = parameterList.getTypeArguments();
        if (psiTypeArray != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl.getTypeParameters must not return null");
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getCachedTextSkipWhiteSpaceAndComments(), false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(PsiClass targetClass) {
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole(this.getFirstChildNode()) == 54;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        PsiElement methodCallCandidate = this.getParent();
        if (methodCallCandidate instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodCallCandidate;
            CodeEditUtil.markToReformat(methodCallExpression.getArgumentList().getNode(), true);
        }
    }

    private String getCachedTextSkipWhiteSpaceAndComments() {
        String whiteSpaceAndComments = this.myCachedTextSkipWhiteSpaceAndComments;
        if (whiteSpaceAndComments == null) {
            this.myCachedTextSkipWhiteSpaceAndComments = whiteSpaceAndComments = SourceUtil.getTextSkipWhiteSpaceAndComments(this);
        }
        return whiteSpaceAndComments;
    }

    private static class TypeEvaluator
    implements NullableFunction<PsiReferenceExpressionImpl, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        public PsiType fun(PsiReferenceExpressionImpl expr) {
            JavaResolveResult result = expr.advancedResolve(false);
            PsiElement resolve = result.getElement();
            if (resolve == null) {
                PsiType type;
                ASTNode qualifier;
                ASTNode refName = expr.findChildByRole(53);
                if (refName != null && "length".equals(refName.getText()) && (qualifier = expr.findChildByRole(54)) != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getElementType()) && (type = ((PsiExpression)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).getType()) instanceof PsiArrayType) {
                    return PsiType.INT;
                }
                return null;
            }
            PsiTarget owner = null;
            PsiType ret = null;
            if (resolve instanceof PsiVariable) {
                PsiType type = ((PsiVariable)resolve).getType();
                PsiType psiType = ret = type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type;
                if (resolve instanceof PsiField && !((PsiField)resolve).hasModifierProperty("static")) {
                    owner = ((PsiField)resolve).getContainingClass();
                }
            } else if (resolve instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolve;
                ret = method.getReturnType();
                owner = method;
            }
            if (ret == null) {
                return null;
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(expr);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (owner == null || !PsiUtil.isRawSubstitutor(owner, substitutor)) {
                    PsiType substitutedType = substitutor.substitute(ret);
                    return PsiImplUtil.normalizeWildcardTypeByPosition(substitutedType, expr);
                }
            }
            return TypeConversionUtil.erasure(ret);
        }
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        private static JavaResolveResult[] _resolve(boolean incompleteCode, PsiReferenceExpressionImpl expression) {
            CompositeElement treeParent = expression.getTreeParent();
            IElementType parentType = treeParent != null ? treeParent.getElementType() : null;
            JavaResolveResult[] result = expression.resolve(parentType);
            if (incompleteCode && parentType != JavaElementType.REFERENCE_EXPRESSION && result.length == 0) {
                return expression.resolve(JavaElementType.REFERENCE_EXPRESSION);
            }
            return result;
        }

        @Override
        public JavaResolveResult[] resolve(PsiJavaReference ref, boolean incompleteCode) {
            JavaResolveResult[] result = OurGenericsResolver._resolve(incompleteCode, (PsiReferenceExpressionImpl)ref);
            if (result.length > 0 && result[0].getElement() instanceof PsiClass) {
                PsiType[] parameters = ((PsiJavaCodeReferenceElement)ref).getTypeParameters();
                JavaResolveResult[] newResult = new JavaResolveResult[result.length];
                for (int i = 0; i < result.length; ++i) {
                    CandidateInfo resolveResult = (CandidateInfo)result[i];
                    newResult[i] = new CandidateInfo(resolveResult, resolveResult.getSubstitutor().putAll((PsiClass)resolveResult.getElement(), parameters));
                }
                return newResult;
            }
            return result;
        }
    }
}

