/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.com.intellij.util.Function;
import org.jetbrains.jet.internal.com.intellij.util.containers.HashMap;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl");
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    @Override
    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.resolveMethodGenerics must not return null");
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.removeChild must not be null");
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceParameterList psiReferenceParameterList;
        PsiReferenceExpression expression = this.getMethodExpression();
        PsiReferenceParameterList result = expression.getParameterList();
        if (result != null) {
            psiReferenceParameterList = result;
            if (psiReferenceParameterList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getTypeArgumentList must not return null");
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString(expression, false));
        psiReferenceParameterList = result;
        if (psiReferenceParameterList != null) return psiReferenceParameterList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getTypeArgumentList must not return null");
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getTypeArguments must not return null");
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getMethodExpression must not return null");
        }
        return psiReferenceExpression;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList psiExpressionList;
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list != null) {
            psiExpressionList = list;
            if (psiExpressionList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getArgumentList must not return null");
            return psiExpressionList;
        }
        LOG.error("Invalid PSI. Children:" + DebugUtil.psiToString(this, false));
        psiExpressionList = list;
        if (psiExpressionList != null) return psiExpressionList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.getArgumentList must not return null");
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodCallExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        @Nullable
        public PsiType fun(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiType theOnly = null;
            JavaResolveResult[] results = methodExpression.multiResolve(false);
            for (int i = 0; i < results.length; ++i) {
                PsiType type = TypeEvaluator.getResultType(call, methodExpression, results[i]);
                if (type == null) {
                    return null;
                }
                if (i == 0) {
                    theOnly = type;
                    continue;
                }
                if (theOnly.equals(type)) continue;
                return null;
            }
            return theOnly;
        }

        @Nullable
        private static PsiType getResultType(PsiExpression call, PsiReferenceExpression methodExpression, JavaResolveResult result) {
            PsiType ret;
            boolean is15OrHigher;
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            PsiManager manager = call.getManager();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call);
            boolean bl = is15OrHigher = languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0;
            if (is15OrHigher && "getClass".equals(method.getName()) && "java.lang.Object".equals(method.getContainingClass().getQualifiedName())) {
                PsiClass javaLangClass;
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                PsiType qualifierType = null;
                if (qualifier != null) {
                    qualifierType = TypeConversionUtil.erasure(qualifier.getType());
                } else {
                    ASTNode parent;
                    for (parent = call.getNode().getTreeParent(); parent != null && parent.getElementType() != JavaElementType.CLASS; parent = parent.getTreeParent()) {
                    }
                    if (parent != null) {
                        qualifierType = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType((PsiClass)parent.getPsi());
                    }
                }
                if (qualifierType != null && (javaLangClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Class", call.getResolveScope())) != null && javaLangClass.getTypeParameters().length == 1) {
                    HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
                    map.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(manager, qualifierType));
                    PsiSubstitutor substitutor = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createSubstitutor(map);
                    return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(javaLangClass, substitutor, languageLevel);
                }
            }
            if ((ret = method.getReturnType()) == null) {
                return null;
            }
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (PsiUtil.isRawSubstitutor(method, substitutor)) {
                    return TypeConversionUtil.erasure(ret);
                }
                PsiType substitutedReturnType = substitutor.substitute(ret);
                PsiType lowerBound = PsiType.NULL;
                if (substitutedReturnType instanceof PsiCapturedWildcardType) {
                    lowerBound = ((PsiCapturedWildcardType)substitutedReturnType).getLowerBound();
                } else if (substitutedReturnType instanceof PsiWildcardType) {
                    lowerBound = ((PsiWildcardType)substitutedReturnType).getSuperBound();
                }
                if (lowerBound != PsiType.NULL) {
                    PsiClassType[] extendsListTypes;
                    PsiType typeInChildClassTypeParams;
                    PsiClass substituted;
                    PsiClass childClass;
                    PsiClass containingClass = method.getContainingClass();
                    PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                    PsiClass psiClass = childClass = qualifierExpression != null ? PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType()) : null;
                    if (containingClass != null && childClass != null && (substituted = PsiUtil.resolveClassInClassTypeOnly(typeInChildClassTypeParams = TypeConversionUtil.getSuperClassSubstitutor(containingClass, childClass, PsiSubstitutor.EMPTY).substitute(ret))) instanceof PsiTypeParameter && (extendsListTypes = substituted.getExtendsListTypes()).length == 1) {
                        return extendsListTypes[0];
                    }
                }
                return PsiImplUtil.normalizeWildcardTypeByPosition(substitutedReturnType, call);
            }
            return TypeConversionUtil.erasure(ret);
        }
    }
}

