/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import java.util.Arrays;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiVariableEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaDummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class PsiLocalVariableImpl
extends CompositePsiElement
implements PsiLocalVariable,
PsiVariableEx,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl");
    private volatile String myCachedName = null;

    public PsiLocalVariableImpl() {
        this(LOCAL_VARIABLE);
    }

    protected PsiLocalVariableImpl(IElementType type) {
        super(type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @Override
    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiElement element = this.findChildByRoleAsPsiElement(9);
        assert (element instanceof PsiIdentifier) : this.getText();
        PsiIdentifier psiIdentifier = (PsiIdentifier)element;
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public final String getName() {
        String cachedName = this.myCachedName;
        if (cachedName == null) {
            this.myCachedName = cachedName = this.getNameIdentifier().getText();
        }
        String string = cachedName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public final PsiType getType() {
        PsiType psiType = JavaSharedImplUtil.getType(this);
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getType must not return null");
        }
        return psiType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement;
        PsiTypeElement typeElement = PsiTreeUtil.getChildOfType(this, PsiTypeElement.class);
        if (typeElement != null) {
            psiTypeElement = typeElement;
            if (psiTypeElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getTypeElement must not return null");
            return psiTypeElement;
        }
        PsiElement parent = this.getParent();
        assert (parent != null) : "no parent; " + this + "; [" + this.getText() + "]";
        PsiLocalVariable localVariable = PsiTreeUtil.getChildOfType(parent, PsiLocalVariable.class);
        assert (localVariable != null) : "no local variable in " + Arrays.toString(parent.getChildren());
        typeElement = PsiTreeUtil.getChildOfType(localVariable, PsiTypeElement.class);
        assert (typeElement != null) : "no type element in " + Arrays.toString(localVariable.getChildren());
        psiTypeElement = typeElement;
        if (psiTypeElement != null) return psiTypeElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getTypeElement must not return null");
    }

    @Override
    public PsiModifierList getModifierList() {
        CompositeElement parent = this.getTreeParent();
        if (parent == null) {
            return null;
        }
        CompositeElement first = (CompositeElement)parent.findChildByType(LOCAL_VARIABLE);
        return first != null ? (PsiModifierList)first.findChildByRoleAsPsiElement(8) : null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.hasModifierProperty must not be null");
        }
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(21);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new THashSet<PsiVariable>());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiType type = this.getType();
        if (!(type instanceof PsiPrimitiveType) && !type.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        PsiElement[] variables;
        CheckUtil.checkWritable(this);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        CompositeElement statement = this.getTreeParent();
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(statement);
        PsiElement[] psiElementArray = variables = psiElement instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)psiElement).getDeclaredElements() : PsiElement.EMPTY_ARRAY;
        if (variables.length > 1) {
            PsiModifierList modifierList = this.getModifierList();
            PsiTypeElement typeElement = this.getTypeElement();
            assert (modifierList != null) : this.getText();
            CompositeElement last = statement;
            for (int i = 1; i < variables.length; ++i) {
                ASTNode typeCopy = typeElement.copy().getNode();
                ASTNode modifierListCopy = modifierList.copy().getNode();
                CompositeElement variable = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(variables[i]);
                ASTNode comma = PsiImplUtil.skipWhitespaceAndCommentsBack(variable.getTreePrev());
                if (comma != null && comma.getElementType() == JavaTokenType.COMMA) {
                    CodeEditUtil.removeChildren(statement, comma, variable.getTreePrev());
                }
                CodeEditUtil.removeChild(statement, variable);
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(statement);
                CompositeElement statement1 = Factory.createCompositeElement(DECLARATION_STATEMENT, charTableByTree, this.getManager());
                statement1.addChild(variable, null);
                LeafElement space = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                variable.addChild(space, variable.getFirstChildNode());
                variable.addChild(typeCopy, variable.getFirstChildNode());
                if (modifierListCopy.getTextLength() > 0) {
                    space = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                    variable.addChild(space, variable.getFirstChildNode());
                }
                variable.addChild(modifierListCopy, variable.getFirstChildNode());
                LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, treeCharTab, this.getManager());
                SourceTreeToPsiMap.psiToTreeNotNull(variables[i - 1]).addChild(semicolon, null);
                CodeEditUtil.addChild(statement.getTreeParent(), statement1, last.getTreeNext());
                last = statement1;
            }
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode eq;
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.deleteChildInternal must not be null");
        }
        if (this.getChildRole(child) == 21 && (eq = this.findChildByRole(20)) != null) {
            this.deleteChildInternal(eq);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 20: {
                return this.findChildByType(JavaTokenType.EQ);
            }
            case 21: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == JavaTokenType.EQ) {
            return this.getChildRole(child, 20);
        }
        if (i == JavaTokenType.SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 21;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLocalVariable(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.processDeclarations must not be null");
        }
        if (lastParent == null) {
            return true;
        }
        if (lastParent.getContext() instanceof JavaDummyHolder) {
            return processor.execute(this, state);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        ASTNode lastParentTree = SourceTreeToPsiMap.psiElementToTree(lastParent);
        return this.getChildRole(lastParentTree) != 21 || processor.execute(this, state);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public String toString() {
        return "PsiLocalVariable:" + this.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope;
        PsiElement parentElement = this.getParent();
        if (parentElement instanceof PsiDeclarationStatement) {
            searchScope = new LocalSearchScope(parentElement.getParent());
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getUseScope must not return null");
            return searchScope;
        }
        searchScope = ResolveScopeManager.getElementUseScope(this);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl.getUseScope must not return null");
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.VARIABLE_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }
}

