/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiLabeledStatementImpl
extends CompositePsiElement
implements PsiLabeledStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiLabeledStatementImpl");

    public PsiLabeledStatementImpl() {
        super(LABELED_STATEMENT);
    }

    @Override
    @NotNull
    public PsiIdentifier getLabelIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.findChildByRoleAsPsiElement(93);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.getLabelIdentifier must not return null");
        }
        return psiIdentifier;
    }

    @Override
    public PsiStatement getStatement() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(94);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 94: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
            case 93: 
        }
        return this.getFirstChildNode();
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == IDENTIFIER) {
            return 93;
        }
        if (i == COLON) {
            return 87;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 94;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLabeledStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiLabeledStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.processDeclarations must not be null");
        }
        if (lastParent != null && lastParent.getParent() != this) {
            PsiElement[] children;
            for (PsiElement aChildren : children = this.getChildren()) {
                if (aChildren.processDeclarations(processor, state, null, place)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.getLabelIdentifier().getText();
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getLabelIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope(this);
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLabeledStatementImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }
}

