/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiInstanceOfExpressionImpl
extends ExpressionPsiElement
implements PsiInstanceOfExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiInstanceOfExpressionImpl");

    public PsiInstanceOfExpressionImpl() {
        super(INSTANCE_OF_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression getOperand() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(67);
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiInstanceOfExpressionImpl.getOperand must not return null");
        }
        return psiExpression;
    }

    @Override
    public PsiTypeElement getCheckType() {
        return (PsiTypeElement)this.findChildByRoleAsPsiElement(10);
    }

    @Override
    public PsiType getType() {
        return PsiType.BOOLEAN;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 67: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 68: {
                return this.findChildByType(INSTANCEOF_KEYWORD);
            }
            case 10: 
        }
        return this.findChildByType(TYPE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TYPE) {
            return 10;
        }
        if (i == INSTANCEOF_KEYWORD) {
            return 68;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiInstanceOfExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitInstanceOfExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiInstanceofExpression:" + this.getText();
    }
}

