/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaToken;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiIdentifierImpl
extends LeafPsiElement
implements PsiIdentifier,
PsiJavaToken {
    public PsiIdentifierImpl(CharSequence text) {
        super(Constants.IDENTIFIER, text);
    }

    @Override
    public IElementType getTokenType() {
        return JavaTokenType.IDENTIFIER;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiIdentifierImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitIdentifier(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiIdentifierImpl.replace must not be null");
        }
        PsiElement result = super.replace(newElement);
        PsiElement methodCandidate = result.getParent();
        if (methodCandidate instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)methodCandidate;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        }
        return result;
    }

    @Override
    public String toString() {
        return "PsiIdentifier:" + this.getText();
    }
}

