/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiExpressionStatementImpl
extends CompositePsiElement
implements PsiExpressionStatement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiExpressionStatementImpl");

    public PsiExpressionStatementImpl() {
        super(JavaElementType.EXPRESSION_STATEMENT);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiExpression getExpression() {
        PsiExpression psiExpression;
        PsiExpression expression = (PsiExpression)SourceTreeToPsiMap.treeElementToPsi(this.findChildByType(ElementType.EXPRESSION_BIT_SET));
        if (expression != null) {
            PsiExpression psiExpression2 = expression;
            psiExpression = psiExpression2;
            if (psiExpression2 != null) return psiExpression;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiExpressionStatementImpl.getExpression must not return null");
        }
        LOG.error("Illegal PSI: \n" + DebugUtil.psiToString(this.getParent(), false));
        psiExpression = null;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiExpressionStatementImpl.getExpression must not return null");
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 64: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 64;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiExpressionStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitExpressionStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiExpressionStatement";
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiExpressionStatementImpl.deleteChildInternal must not be null");
        }
        if (this.getChildRole(child) == 64) {
            this.getTreeParent().deleteChildInternal(this);
        } else {
            super.deleteChildInternal(child);
        }
    }
}

