/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDoWhileStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaToken;
import org.jetbrains.jet.internal.com.intellij.psi.PsiKeyword;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiDoWhileStatementImpl
extends CompositePsiElement
implements PsiDoWhileStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiDoWhileStatementImpl");

    public PsiDoWhileStatementImpl() {
        super(DO_WHILE_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @Override
    public PsiKeyword getWhileKeyword() {
        return (PsiKeyword)this.findChildByRoleAsPsiElement(35);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 36: {
                return this.findChildByType(DO_KEYWORD);
            }
            case 38: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 35: {
                return this.findChildByType(WHILE_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == DO_KEYWORD) {
            return 36;
        }
        if (i == WHILE_KEYWORD) {
            return 35;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 38;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiDoWhileStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDoWhileStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiDoWhileStatement";
    }
}

