/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiContinueStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiLabelReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiContinueStatementImpl
extends CompositePsiElement
implements PsiContinueStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiContinueStatementImpl");

    public PsiContinueStatementImpl() {
        super(CONTINUE_STATEMENT);
    }

    @Override
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findChildByRoleAsPsiElement(83);
    }

    @Override
    public PsiStatement findContinuedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label == null) {
            for (ASTNode parent = this.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                IElementType i = parent.getElementType();
                if (i == FOR_STATEMENT || i == FOREACH_STATEMENT || i == WHILE_STATEMENT || i == DO_WHILE_STATEMENT) {
                    return (PsiStatement)SourceTreeToPsiMap.treeElementToPsi(parent);
                }
                if (i != METHOD && i != CLASS_INITIALIZER) continue;
                return null;
            }
        } else {
            String labelName = label.getText();
            for (CompositeElement parent = this.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                TreeElement statementLabel;
                if (parent.getElementType() == LABELED_STATEMENT && (statementLabel = (TreeElement)parent.findChildByRole(93)).textMatches(labelName)) {
                    return ((PsiLabeledStatement)SourceTreeToPsiMap.treeElementToPsi(parent)).getStatement();
                }
                if (parent.getElementType() != METHOD && parent.getElementType() != CLASS_INITIALIZER) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 82: {
                return this.findChildByType(CONTINUE_KEYWORD);
            }
            case 83: {
                return this.findChildByType(IDENTIFIER);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == CONTINUE_KEYWORD) {
            return 82;
        }
        if (i == IDENTIFIER) {
            return 83;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiContinueStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitContinueStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiContinueStatement";
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references != null && references.length > 0) {
            return references[0];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        if (this.getLabelIdentifier() == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiContinueStatementImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = new PsiReference[]{new PsiLabelReference(this, this.getLabelIdentifier())};
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiContinueStatementImpl.getReferences must not return null");
    }
}

