/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaToken;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiStatement;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.scope.BaseScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.NameHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.gnu.trove.THashSet;

public class PsiCodeBlockImpl
extends LazyParseablePsiElement
implements PsiCodeBlock {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiCodeBlockImpl");
    private volatile Set<String> myVariablesSet = null;
    private volatile Set<String> myClassesSet = null;
    private volatile boolean myConflict = false;

    public PsiCodeBlockImpl(CharSequence text) {
        super(JavaElementType.CODE_BLOCK, text);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myVariablesSet = null;
        this.myClassesSet = null;
        this.myConflict = false;
    }

    @Override
    @NotNull
    public PsiStatement[] getStatements() {
        PsiStatement[] psiStatementArray = PsiImplUtil.getChildStatements(this);
        if (psiStatementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl.getStatements must not return null");
        }
        return psiStatementArray;
    }

    @Override
    public PsiElement getFirstBodyElement() {
        PsiJavaToken lBrace = this.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement nextSibling = lBrace.getNextSibling();
        return nextSibling == this.getRBrace() ? null : nextSibling;
    }

    @Override
    public PsiElement getLastBodyElement() {
        PsiJavaToken rBrace = this.getRBrace();
        if (rBrace != null) {
            PsiElement prevSibling = rBrace.getPrevSibling();
            return prevSibling == this.getLBrace() ? null : prevSibling;
        }
        return this.getLastChild();
    }

    @Override
    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(18);
    }

    @Override
    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(19);
    }

    @Nullable
    private Pair<Set<String>, Set<String>> buildMaps() {
        Set<String> set1 = this.myClassesSet;
        Set<String> set2 = this.myVariablesSet;
        boolean wasConflict = this.myConflict;
        if (set1 == null || set2 == null) {
            final THashSet localsSet = new THashSet();
            final THashSet classesSet = new THashSet();
            final Ref<Boolean> conflict = new Ref<Boolean>(Boolean.FALSE);
            PsiScopesUtil.walkChildrenScopes(this, new BaseScopeProcessor(){

                @Override
                public boolean execute(PsiElement element, ResolveState state) {
                    PsiClass psiClass;
                    String name;
                    if (element instanceof PsiLocalVariable) {
                        PsiLocalVariable variable = (PsiLocalVariable)element;
                        String name2 = variable.getName();
                        if (!localsSet.add(name2)) {
                            conflict.set(Boolean.TRUE);
                            localsSet.clear();
                            classesSet.clear();
                        }
                    } else if (element instanceof PsiClass && !classesSet.add(name = (psiClass = (PsiClass)element).getName())) {
                        conflict.set(Boolean.TRUE);
                        localsSet.clear();
                        classesSet.clear();
                    }
                    return (Boolean)conflict.get() == false;
                }
            }, ResolveState.initial(), this, this);
            set1 = classesSet.isEmpty() ? Collections.emptySet() : classesSet;
            this.myClassesSet = set1;
            set2 = localsSet.isEmpty() ? Collections.emptySet() : localsSet;
            this.myVariablesSet = set2;
            this.myConflict = wasConflict = conflict.get().booleanValue();
        }
        return wasConflict ? null : Pair.create(set1, set2);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        block6: {
            block5: {
                if (anchor == null) {
                    if (before == null || before.booleanValue()) {
                        anchor = this.findChildByRole(19);
                        before = Boolean.TRUE;
                    } else {
                        anchor = this.findChildByRole(18);
                        before = Boolean.FALSE;
                    }
                }
                if (before != Boolean.TRUE) break block5;
                while (PsiCodeBlockImpl.isNonJavaStatement(anchor)) {
                    anchor = anchor.getTreePrev();
                    before = Boolean.FALSE;
                }
                break block6;
            }
            if (before != Boolean.FALSE) break block6;
            while (PsiCodeBlockImpl.isNonJavaStatement(anchor)) {
                anchor = anchor.getTreeNext();
                before = Boolean.TRUE;
            }
        }
        return super.addInternal(first, last, anchor, before);
    }

    private static boolean isNonJavaStatement(ASTNode anchor) {
        PsiElement psi = anchor.getPsi();
        return psi instanceof PsiStatement && psi.getLanguage() != JavaLanguage.INSTANCE;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.RBRACE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.LBRACE) {
            return this.getChildRole(child, 18);
        }
        if (i == JavaTokenType.RBRACE) {
            return this.getChildRole(child, 19);
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCodeBlock(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiCodeBlock";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null) {
            return true;
        }
        Pair<Set<String>, Set<String>> pair = this.buildMaps();
        boolean conflict = pair == null;
        Set<String> classesSet = conflict ? null : pair.getFirst();
        Set<String> variablesSet = conflict ? null : pair.getSecond();
        NameHint hint = processor.getHint(NameHint.KEY);
        if (hint != null && !conflict) {
            ElementClassHint elementClassHint = processor.getHint(ElementClassHint.KEY);
            String name = hint.getName(state);
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && classesSet.contains(name)) {
                return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
            }
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) && variablesSet.contains(name)) {
                return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
            }
        } else {
            return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        PsiElement parent = this.getParent();
        return !(parent instanceof PsiMethod) && !(parent instanceof PsiClassInitializer);
    }
}

