/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaToken;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.jet.internal.com.intellij.util.Function;

public class PsiBinaryExpressionImpl
extends ExpressionPsiElement
implements PsiBinaryExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiBinaryExpressionImpl");
    private static final Function<PsiBinaryExpressionImpl, PsiType> MY_TYPE_EVALUATOR = new Function<PsiBinaryExpressionImpl, PsiType>(){

        @Override
        public PsiType fun(PsiBinaryExpressionImpl expression) {
            return PsiBinaryExpressionImpl.doGetType(expression);
        }
    };
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create(JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);

    public PsiBinaryExpressionImpl() {
        this(JavaElementType.BINARY_EXPRESSION);
    }

    protected PsiBinaryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.<init> must not be null");
        }
        super(elementType);
    }

    @Override
    @NotNull
    public PsiExpression getLOperand() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(61);
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getLOperand must not return null");
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getROperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(62);
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
        if (psiJavaToken == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getOperationSign must not return null");
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.getOperationSign().getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getOperationTokenType must not return null");
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getTokenBeforeOperand must not be null");
        }
        if (operand != this.getROperand()) {
            return null;
        }
        return this.getOperationSign();
    }

    private static PsiType doGetType(PsiBinaryExpressionImpl param) {
        IElementType sign;
        PsiExpression lOperand = param.getLOperand();
        PsiExpression rOperand = param.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiType rType = rOperand.getType();
        PsiType type = TypeConversionUtil.calcTypeForBinaryExpression(null, rType, sign = param.getOperationTokenType(), false);
        if (type != TypeConversionUtil.NULL_TYPE) {
            return type;
        }
        if (lOperand instanceof PsiBinaryExpressionImpl && !JavaResolveCache.getInstance(param.getProject()).isTypeCached(lOperand)) {
            PsiBinaryExpressionImpl topLevel = param;
            PsiElement element = param;
            while (element instanceof PsiBinaryExpressionImpl) {
                topLevel = element;
                element = element.getParent();
            }
            topLevel.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                protected void elementFinished(PsiElement element) {
                    if (element instanceof PsiExpression) {
                        ProgressIndicatorProvider.checkCanceled();
                        ((PsiExpression)element).getType();
                    }
                }
            });
        }
        PsiType lType = lOperand.getType();
        return TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, sign, true);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 61: {
                return this.getFirstChildNode();
            }
            case 62: {
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            if (child == this.getFirstChildNode()) {
                return 61;
            }
            if (child == this.getLastChildNode()) {
                return 62;
            }
            return 0;
        }
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitBinaryExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }

    @Override
    @NotNull
    public PsiExpression[] getOperands() {
        PsiExpression[] psiExpressionArray;
        PsiExpression rOperand = this.getROperand();
        if (rOperand == null) {
            PsiExpression[] psiExpressionArray2 = new PsiExpression[1];
            psiExpressionArray = psiExpressionArray2;
            psiExpressionArray2[0] = this.getLOperand();
        } else {
            PsiExpression[] psiExpressionArray3 = new PsiExpression[2];
            psiExpressionArray3[0] = this.getLOperand();
            psiExpressionArray = psiExpressionArray3;
            psiExpressionArray3[1] = rOperand;
        }
        if (psiExpressionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl.getOperands must not return null");
        }
        return psiExpressionArray;
    }
}

