/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAssertStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;

public class PsiAssertStatementImpl
extends CompositePsiElement
implements PsiAssertStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiAssertStatementImpl");

    public PsiAssertStatementImpl() {
        super(ASSERT_STATEMENT);
    }

    @Override
    public PsiExpression getAssertCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiExpression getAssertDescription() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(117);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 116: {
                return this.findChildByType(ASSERT_KEYWORD);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
            case 117: {
                ASTNode child;
                ASTNode colon = this.findChildByRole(87);
                if (colon == null) {
                    return null;
                }
                for (child = colon.getTreeNext(); child != null && !EXPRESSION_BIT_SET.contains(child.getElementType()); child = child.getTreeNext()) {
                }
                return child;
            }
            case 22: 
        }
        return this.findChildByType(SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == ASSERT_KEYWORD) {
            return 116;
        }
        if (i == COLON) {
            return 87;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            int role = this.getChildRole(child, 32);
            if (role != 0) {
                return role;
            }
            return 117;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiAssertStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAssertStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiAssertStatement";
    }
}

