/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNewExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.FieldElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;

public class PsiArrayInitializerExpressionImpl
extends ExpressionPsiElement
implements PsiArrayInitializerExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiArrayInitializerExpressionImpl");

    public PsiArrayInitializerExpressionImpl() {
        super(ARRAY_INITIALIZER_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression[] getInitializers() {
        PsiExpression[] psiExpressionArray = (PsiExpression[])this.getChildrenAsPsiElements(EXPRESSION_BIT_SET, PSI_EXPRESSION_ARRAY_CONSTRUCTOR);
        if (psiExpressionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiArrayInitializerExpressionImpl.getInitializers must not return null");
        }
        return psiExpressionArray;
    }

    @Override
    public PsiType getType() {
        if (this.getTreeParent() instanceof PsiNewExpression) {
            if (this.getTreeParent().getChildRole(this) == 77) {
                return ((PsiNewExpression)((Object)this.getTreeParent())).getType();
            }
        } else {
            if (this.getTreeParent() instanceof PsiVariable) {
                return ((PsiVariable)((Object)this.getTreeParent())).getType();
            }
            if (this.getTreeParent() instanceof PsiArrayInitializerExpression) {
                PsiType parentType = ((PsiArrayInitializerExpression)((Object)this.getTreeParent())).getType();
                if (!(parentType instanceof PsiArrayType)) {
                    return null;
                }
                PsiType componentType = ((PsiArrayType)parentType).getComponentType();
                return componentType instanceof PsiArrayType ? componentType : null;
            }
            if (this.getTreeParent() instanceof FieldElement) {
                return ((PsiField)this.getParent()).getType();
            }
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(LBRACE);
            }
            case 19: 
        }
        return this.findChildByType(RBRACE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == COMMA) {
            return 23;
        }
        if (i == LBRACE) {
            return 18;
        }
        if (i == RBRACE) {
            return 19;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiArrayInitializerExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitArrayInitializerExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiArrayInitializerExpression:" + this.getText();
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(19);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(18);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (ElementType.EXPRESSION_BIT_SET.contains(first.getElementType())) {
            LeafElement comma;
            ASTNode child;
            CharTable charTab = SharedImplUtil.findCharTableByTree(this);
            TreeElement element = first;
            for (child = element.getTreeNext(); child != null && child.getElementType() != COMMA; child = child.getTreeNext()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, charTab, this.getManager());
                super.addInternal(comma, comma, element, Boolean.FALSE);
                break;
            }
            for (child = element.getTreePrev(); child != null && child.getElementType() != COMMA; child = child.getTreePrev()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, charTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        return firstAdded;
    }
}

