/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiCommaSeparatedListImpl;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiAnnotationParameterListImpl
extends PsiCommaSeparatedListImpl
implements PsiAnnotationParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiAnnotationParameterListImpl");
    private volatile PsiNameValuePair[] myCachedMembers = null;

    public PsiAnnotationParameterListImpl() {
        super(ANNOTATION_PARAMETER_LIST, NAME_VALUE_PAIR_BIT_SET);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedMembers = null;
    }

    @Override
    @NotNull
    public PsiNameValuePair[] getAttributes() {
        PsiNameValuePair[] cachedMembers = this.myCachedMembers;
        if (cachedMembers == null) {
            cachedMembers = (PsiNameValuePair[])this.getChildrenAsPsiElements(NAME_VALUE_PAIR_BIT_SET, PSI_NAME_VALUE_PAIR_ARRAY_CONSTRUCTOR);
            this.myCachedMembers = cachedMembers;
        }
        if (cachedMembers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationParameterListImpl.getAttributes must not return null");
        }
        return cachedMembers;
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType i = child.getElementType();
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getElementType()) || i == NAME_VALUE_PAIR && child.getFirstChildNode() != null && child.getFirstChildNode().getElementType() == ANNOTATION_ARRAY_INITIALIZER) {
            return 249;
        }
        return 0;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                LOG.assertTrue(false);
                return null;
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 25: 
        }
        return this.findChildByType(RPARENTH);
    }

    @Override
    public String toString() {
        return "PsiAnnotationParameterList";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiAnnotationParameterListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first.getElementType() == NAME_VALUE_PAIR && last.getElementType() == NAME_VALUE_PAIR) {
            PsiNameValuePair pair;
            ASTNode node;
            ASTNode[] nodes;
            ASTNode rparenth;
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            ASTNode lparenth = this.findChildByRole(24);
            if (lparenth == null) {
                LeafElement created = Factory.createSingleLeafElement(LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getFirstChildNode(), true);
            }
            if ((rparenth = this.findChildByRole(25)) == null) {
                LeafElement created = Factory.createSingleLeafElement(RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getLastChildNode(), false);
            }
            if ((nodes = this.getChildren(NAME_VALUE_PAIR_BIT_SET)).length == 1 && (node = nodes[0]) instanceof PsiNameValuePair && (pair = (PsiNameValuePair)((Object)node)).getName() == null) {
                String text = pair.getValue().getText();
                try {
                    PsiAnnotation annotation = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createAnnotationFromText("@AAA(value = " + text + ")", null);
                    this.replaceChild(node, annotation.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            if (anchor == null && before != null) {
                anchor = this.findChildByRole(before != false ? 25 : 24);
            }
        }
        return super.addInternal(first, last, anchor, before);
    }
}

