/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayInitializerMemberValue;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodReceiver;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.meta.MetaRegistry;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.util.PairFunction;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl");
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        @Override
        public PsiAnnotation fun(Project project, String text) {
            return JavaPsiFacade.getInstance(project).getElementFactory().createAnnotationFromText(text, null);
        }
    };

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return (PsiJavaCodeReferenceElement)stub.getTreeElement().findChildByRoleAsPsiElement(119);
        }
        PsiJavaCodeReferenceElement result = PsiTreeUtil.getChildOfType(this, PsiJavaCodeReferenceElement.class);
        if (result != null && !(result instanceof PsiJavaCodeReferenceElement)) {
            throw new AssertionError((Object)("getChildOfType returned rubbish: " + result));
        }
        return result;
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value, ANNOTATION_CREATOR);
    }

    @Override
    public String toString() {
        return "PsiAnnotation";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList;
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            psiAnnotationParameterList = (PsiAnnotationParameterList)stub.getTreeElement().findChildByRoleAsPsiElement(14);
            if (psiAnnotationParameterList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.getParameterList must not return null");
            return psiAnnotationParameterList;
        }
        psiAnnotationParameterList = PsiTreeUtil.getRequiredChildOfType(this, PsiAnnotationParameterList.class);
        if (psiAnnotationParameterList != null) return psiAnnotationParameterList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.getParameterList must not return null");
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }

    @Override
    public PsiAnnotationOwner getOwner() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiTypeElement) {
            return ((PsiTypeElement)parent).getOwner(this);
        }
        if (parent instanceof PsiMethodReceiver || parent instanceof PsiTypeParameter) {
            return (PsiAnnotationOwner)((Object)parent);
        }
        PsiElement member = parent.getParent();
        String[] elementTypeFields = PsiAnnotationImpl.getApplicableElementTypeFields(member);
        if (elementTypeFields == null) {
            return null;
        }
        if (parent instanceof PsiAnnotationOwner && PsiAnnotationImpl.isAnnotationApplicableTo(this, true, elementTypeFields)) {
            return (PsiAnnotationOwner)((Object)parent);
        }
        PsiAnnotationOwner typeElement = member instanceof PsiVariable ? ((PsiVariable)member).getTypeElement() : (member instanceof PsiMethod && !((PsiMethod)member).isConstructor() ? ((PsiMethod)member).getReturnTypeElement() : (parent instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)((Object)parent) : null));
        return typeElement;
    }

    public static boolean isAnnotationApplicableTo(PsiAnnotation annotation, boolean strict, String ... elementTypeFields) {
        if (elementTypeFields == null) {
            return true;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return !strict;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) {
            return !strict;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiAnnotation target = annotationType.getModifierList().findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return !strict;
        }
        PsiNameValuePair[] attributes = target.getParameterList().getAttributes();
        if (attributes.length == 0) {
            return !strict;
        }
        PsiAnnotationMemberValue value = attributes[0].getValue();
        LOG.assertTrue(elementTypeFields.length > 0);
        PsiManager manager = annotation.getManager();
        PsiClass elementTypeClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.annotation.ElementType", annotation.getResolveScope());
        if (elementTypeClass == null) {
            return !strict;
        }
        for (String fieldName : elementTypeFields) {
            PsiField field = elementTypeClass.findFieldByName(fieldName, false);
            if (field == null) continue;
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                    PsiReferenceExpression refExpr;
                    if (!(initializer instanceof PsiReferenceExpression) || !(refExpr = (PsiReferenceExpression)initializer).isReferenceTo(field)) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof PsiReferenceExpression) || !((PsiReferenceExpression)value).isReferenceTo(field)) continue;
            return true;
        }
        return false;
    }

    public static String[] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                return new String[]{"ANNOTATION_TYPE", "TYPE"};
            }
            if (aClass instanceof PsiTypeParameter) {
                return new String[]{"TYPE_PARAMETER"};
            }
            return new String[]{"TYPE"};
        }
        if (owner instanceof PsiMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                return new String[]{"CONSTRUCTOR"};
            }
            return new String[]{"METHOD"};
        }
        if (owner instanceof PsiField) {
            return new String[]{"FIELD"};
        }
        if (owner instanceof PsiParameter) {
            return new String[]{"PARAMETER"};
        }
        if (owner instanceof PsiLocalVariable) {
            return new String[]{"LOCAL_VARIABLE"};
        }
        if (owner instanceof PsiPackageStatement) {
            return new String[]{"PACKAGE"};
        }
        if (owner instanceof PsiTypeElement) {
            return new String[]{"TYPE_USE"};
        }
        return null;
    }
}

