/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;

public class MethodElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.MethodElement");

    public MethodElement() {
        super(METHOD);
    }

    protected MethodElement(IElementType type) {
        super(type);
    }

    @Override
    public int getTextOffset() {
        return this.findChildByRole(9).getStartOffset();
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode semicolon;
        if (first == last && first.getElementType() == ElementType.CODE_BLOCK && (semicolon = this.findChildByRole(22)) != null) {
            this.deleteChildInternal(semicolon);
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public ASTNode copyElement() {
        CharTable table = SharedImplUtil.findCharTableByTree(this);
        PsiClass psiClass = ((PsiMethod)this.getPsi()).getContainingClass();
        return psiClass != null ? ChangeUtil.copyElement(this, psiClass.getTypeParameterList(), table) : super.copyElement();
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/MethodElement.deleteChildInternal must not be null");
        }
        if (child.getElementType() == CODE_BLOCK) {
            ASTNode prevWS = TreeUtil.prevLeaf(child);
            if (prevWS != null && prevWS.getElementType() == TokenType.WHITE_SPACE) {
                this.removeChild(prevWS);
            }
            super.deleteChildInternal(child);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            LeafElement semicolon = Factory.createSingleLeafElement(SEMICOLON, ";", 0, 1, treeCharTab, this.getManager());
            this.addInternal(semicolon, semicolon, null, Boolean.TRUE);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 7: {
                return PsiImplUtil.findDocComment(this);
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 245: {
                return this.findChildByType(TYPE_PARAMETER_LIST);
            }
            case 9: {
                return this.findChildByType(IDENTIFIER);
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 17: {
                return this.findChildByType(CODE_BLOCK);
            }
            case 14: {
                return this.findChildByType(PARAMETER_LIST);
            }
            case 16: {
                return this.findChildByType(THROWS_LIST);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaDocElementType.DOC_COMMENT) {
            return this.getChildRole(child, 7);
        }
        if (i == C_STYLE_COMMENT || i == END_OF_LINE_COMMENT) {
            return 0;
        }
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == TYPE_PARAMETER_LIST) {
            return 245;
        }
        if (i == CODE_BLOCK) {
            return 17;
        }
        if (i == PARAMETER_LIST) {
            return 14;
        }
        if (i == THROWS_LIST) {
            return 16;
        }
        if (i == TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        return 0;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

