/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import java.util.HashSet;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lexer.Lexer;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;

public class TreeUtil {
    public static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create("UNCLOSED_ELEMENT_PROPERTY");
    public static Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create("CONTAINING_FILE_KEY_AFTER_REPARSE");

    private TreeUtil() {
    }

    public static void ensureParsed(ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static void ensureParsedRecursively(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.ensureParsedRecursively must not be null");
        }
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public static void ensureParsedRecursivelyCheckingProgress(@NotNull ASTNode node, final ProgressIndicator indicator) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.ensureParsedRecursivelyCheckingProgress must not be null");
        }
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
            }
        });
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(ASTNode parent, IElementType type) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = parent.getLastChildNode(); element != null; element = element.getTreePrev()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(ASTNode element, TokenSet types) {
        while (true) {
            if (element == null) {
                return null;
            }
            if (!types.contains(element.getElementType())) break;
            element = element.getTreeNext();
        }
        return element;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element, TokenSet types) {
        if (element == null) {
            return null;
        }
        if (!types.contains(element.getElementType())) {
            return element;
        }
        ASTNode parent = element.getTreeParent();
        ASTNode prev = element;
        while (prev instanceof CompositeElement) {
            if (!types.contains(prev.getElementType())) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (types.contains(firstChildNode.getElementType())) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, IElementType type) {
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (parent.getElementType() != type) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(ASTNode element) {
        if (element instanceof LeafElement) {
            return (LeafElement)element;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            LeafElement leaf = TreeUtil.findFirstLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    public static boolean isLeafOrCollapsedChameleon(ASTNode node) {
        return node instanceof LeafElement || TreeUtil.isCollapsedChameleon(node);
    }

    @Nullable
    public static TreeElement findFirstLeafOrChameleon(TreeElement element) {
        if (element == null) {
            return null;
        }
        final Ref<Object> result = Ref.create(null);
        element.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (TreeUtil.isLeafOrCollapsedChameleon(element)) {
                    result.set(element);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element);
            }
        });
        return result.get();
    }

    @Nullable
    public static ASTNode findLastLeaf(ASTNode element) {
        if (element instanceof LeafElement) {
            return element;
        }
        for (ASTNode child = element.getLastChildNode(); child != null; child = child.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents = new HashSet<ASTNode>(20);
        while (one != null) {
            parents.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    public static Pair<ASTNode, ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            return Pair.create(null, null);
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        return new Pair<ASTNode, ASTNode>(one, two);
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.clearCaches must not be null");
        }
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                element.clearCaches();
                super.visitNode(element);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.nextLeaf must not be null");
        }
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    public static FileElement getFileElement(TreeElement element) {
        TreeElement parent;
        for (parent = element; parent != null && !(parent instanceof FileElement); parent = parent.getTreeParent()) {
        }
        if (parent == null) {
            parent = element.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type) {
        return type instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return ((Object)lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd())).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent) {
        if (start == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.nextLeaf must not be null");
        }
        return (LeafElement)TreeUtil.nextLeaf(start, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        TreeElement element;
        if (start == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.nextLeaf must not be null");
        }
        for (element = start; element != null; element = element.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element, true);
            }
            TreeElement nextTree = element;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next;
        }
        return element;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start, boolean slopeSide) {
        if (start instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start.getElementType()) || slopeSide && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/TreeUtil.findFirstLeafOrType must not be null");
        }
        class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            TreeElement result;

            MyVisitor(boolean doTransform) {
                super(doTransform);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor = new MyVisitor(expandChameleons);
        element.acceptTree(visitor);
        return visitor.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start, @Nullable CommonParentState commonParent) {
        while (start != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
                }
                commonParent.nextLeafBranchStart = start;
            }
            ASTNode prevTree = start;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element) {
        ASTNode child = element;
        while (child != null) {
            element = child;
            child = element.getLastChildNode();
        }
        return element;
    }

    public static final class CommonParentState {
        public TreeElement startLeafBranchStart = null;
        public ASTNode nextLeafBranchStart = null;
        public CompositeElement strongWhiteSpaceHolder = null;
        public boolean isStrongElementOnRisingSlope = true;
    }
}

