/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.jet.internal.com.intellij.lang.ASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.AstBufferUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class SourceUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.SourceUtil");

    private SourceUtil() {
    }

    public static String getTextSkipWhiteSpaceAndComments(ASTNode element) {
        return AstBufferUtil.getTextSkippingWhitespaceComments(element);
    }

    public static String getTextSkipWhiteSpaceAndComments(LighterAST tree, LighterASTNode node) {
        return LightTreeUtil.toFilteredString(tree, node, ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET);
    }

    public static TreeElement addParenthToReplacedChild(IElementType parenthType, TreeElement newChild, PsiManager manager) {
        CompositeElement parenthExpr = ASTFactory.composite(parenthType);
        TreeElement dummyExpr = (TreeElement)newChild.clone();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(newChild);
        new DummyHolder(manager, parenthExpr, null, charTableByTree);
        parenthExpr.putUserData(CharTable.CHAR_TABLE_KEY, charTableByTree);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.LPARENTH, "("));
        parenthExpr.rawAddChildren(dummyExpr);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.RPARENTH, ")"));
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(manager.getProject());
            parenthExpr = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(codeStyleManager.reformat(SourceTreeToPsiMap.treeElementToPsi(parenthExpr)));
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        newChild.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(newChild));
        dummyExpr.rawReplaceWithList(newChild);
        newChild = parenthExpr;
        TreeUtil.clearCaches(TreeUtil.getFileElement(newChild));
        return newChild;
    }
}

