/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.LighterAST;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.jet.internal.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class LightTreeUtil {
    private LightTreeUtil() {
    }

    @Nullable
    public static LighterASTNode firstChildOfType(LighterAST tree, LighterASTNode node, IElementType type) {
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(LighterAST tree, LighterASTNode node, IElementType type) {
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not return null");
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(LighterAST tree, LighterASTNode node, IElementType type) {
        List<LighterASTNode> result = null;
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type) continue;
            if (result == null) {
                result = new SmartList<LighterASTNode>();
            }
            result.add(child);
        }
        List<LighterASTNode> list = result != null ? result : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.getChildrenOfType must not return null");
        }
        return list;
    }

    public static String toFilteredString(LighterAST tree, LighterASTNode node, @Nullable TokenSet skipTypes) {
        StringBuilder buffer = new StringBuilder(node.getEndOffset() - node.getStartOffset());
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        return buffer.toString();
    }

    private static void toBuffer(LighterAST tree, LighterASTNode node, StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, children.get(i), buffer, skipTypes);
        }
    }
}

