/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceJavaCodeReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;

public class JavaSourceUtil {
    private JavaSourceUtil() {
    }

    public static void fullyQualifyReference(CompositeElement reference, PsiClass targetClass) {
        if (((SourceJavaCodeReference)((Object)reference)).isQualified()) {
            PsiClass parentClass = targetClass.getContainingClass();
            if (parentClass == null) {
                return;
            }
            ASTNode qualifier = reference.findChildByRole(54);
            if (qualifier instanceof SourceJavaCodeReference) {
                ((SourceJavaCodeReference)((Object)qualifier)).fullyQualify(parentClass);
            }
        } else {
            String qName = targetClass.getQualifiedName();
            if (qName == null) {
                return;
            }
            int i = qName.lastIndexOf(46);
            if (i > 0) {
                String prefix = qName.substring(0, i);
                PsiManagerEx manager = reference.getManager();
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
                TreeElement qualifier = reference instanceof PsiReferenceExpression ? (TreeElement)parserFacade.createExpressionFromText(prefix, null).getNode() : (TreeElement)parserFacade.createReferenceFromText(prefix, null).getNode();
                if (qualifier != null) {
                    CharTable systemCharTab = SharedImplUtil.findCharTableByTree(qualifier);
                    LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, systemCharTab, manager);
                    qualifier.rawInsertAfterMe(dot);
                    reference.addInternal(qualifier, dot, null, Boolean.FALSE);
                }
            }
        }
    }
}

