/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiTypeElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(PsiVariable variable) {
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        return JavaSharedImplUtil.getType(typeElement, nameIdentifier, variable);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @NotNull PsiElement context) {
        if (typeElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getType must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getType must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getType must not be null");
        }
        int cStyleArrayCount = 0;
        ASTNode name = SourceTreeToPsiMap.psiElementToTree(anchor);
        for (ASTNode child = name.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType i = child.getElementType();
            if (i == JavaTokenType.LBRACKET) {
                ++cStyleArrayCount;
                continue;
            }
            if (i != JavaTokenType.RBRACKET && i != TokenType.WHITE_SPACE && i != JavaTokenType.C_STYLE_COMMENT && i != JavaDocElementType.DOC_COMMENT && i != JavaTokenType.END_OF_LINE_COMMENT) break;
        }
        PsiType type = typeElement instanceof PsiTypeElementImpl ? ((PsiTypeElementImpl)typeElement).getDetachedType(context) : typeElement.getType();
        for (int i = 0; i < cStyleArrayCount; ++i) {
            type = type.createArrayType();
        }
        return type;
    }

    public static PsiType getTypeNoResolve(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @NotNull PsiElement context) {
        if (typeElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getTypeNoResolve must not be null");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getTypeNoResolve must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaSharedImplUtil.getTypeNoResolve must not be null");
        }
        int cStyleArrayCount = 0;
        ASTNode name = SourceTreeToPsiMap.psiElementToTree(anchor);
        for (ASTNode child = name.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType i = child.getElementType();
            if (i == JavaTokenType.LBRACKET) {
                ++cStyleArrayCount;
                continue;
            }
            if (i != JavaTokenType.RBRACKET && i != TokenType.WHITE_SPACE && i != JavaTokenType.C_STYLE_COMMENT && i != JavaDocElementType.DOC_COMMENT && i != JavaTokenType.END_OF_LINE_COMMENT) break;
        }
        PsiType type = typeElement.getTypeNoResolve(context);
        for (int i = 0; i < cStyleArrayCount; ++i) {
            type = type.createArrayType();
        }
        return type;
    }

    public static void normalizeBrackets(PsiVariable variable) {
        CompositeElement variableElement = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(variable);
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type = typeElement.getNode();
        ASTNode name = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                variableElement.removeChild(element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type));
            variableElement.replaceChild(type, newType);
        }
    }

    public static void setInitializer(PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer = variable.getInitializer();
        if (oldInitializer != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier element = variable.getNameIdentifier();
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(element.getNode().getTreeNext(), TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET));
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
        }
        variable.addAfter(initializer, eq.getPsi());
    }
}

