/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.FileASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.CharTableImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;

public class FileElement
extends LazyParseableElement
implements FileASTNode {
    private volatile CharTable myCharTable = new CharTableImpl();

    @Override
    @NotNull
    public CharTable getCharTable() {
        CharTable charTable = this.myCharTable;
        if (charTable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/FileElement.getCharTable must not return null");
        }
        return charTable;
    }

    public FileElement(IElementType type, CharSequence text) {
        super(type, text);
    }

    @Deprecated
    public FileElement(IElementType type) {
        super(type, null);
    }

    @Override
    public PsiManagerEx getManager() {
        if (this.getTreeParent() != null) {
            return this.getTreeParent().getManager();
        }
        return (PsiManagerEx)this.getPsi().getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(CharTable table) {
        this.myCharTable = table;
    }
}

