/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.jet.internal.com.intellij.lang.ASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.DefaultASTFactory;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.javadoc.CorePsiDocTagValueImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.javadoc.PsiDocTokenImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiIdentifierImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiJavaTokenImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiKeywordImpl;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.java.IJavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.java.IJavaElementType;

public class CoreJavaASTFactory
extends ASTFactory
implements Constants {
    private final DefaultASTFactory myDefaultASTFactory = ServiceManager.getService(DefaultASTFactory.class);

    @Override
    public LeafElement createLeaf(IElementType type, CharSequence text) {
        if (type == C_STYLE_COMMENT || type == END_OF_LINE_COMMENT) {
            return this.myDefaultASTFactory.createComment(type, text);
        }
        if (type == IDENTIFIER) {
            return new PsiIdentifierImpl(text);
        }
        if (KEYWORD_BIT_SET.contains(type)) {
            return new PsiKeywordImpl(type, text);
        }
        if (type instanceof IJavaElementType) {
            return new PsiJavaTokenImpl(type, text);
        }
        if (type instanceof IJavaDocElementType) {
            assert (type != DOC_TAG_VALUE_ELEMENT);
            return new PsiDocTokenImpl(type, text);
        }
        return null;
    }

    @Override
    public CompositeElement createComposite(IElementType type) {
        if (type == DOC_TAG_VALUE_ELEMENT) {
            return new CorePsiDocTagValueImpl();
        }
        return null;
    }
}

