/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.diagnostic.ThreadDumper;
import org.jetbrains.jet.internal.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.jet.internal.com.intellij.lang.ASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.TreeChangeEvent;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiLock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolderElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiElementArrayConstructor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.AstBufferUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.util.ArrayFactory;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayCharSequence;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.CompositeElement");
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myModificationsCount;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final RecursiveTreeElementWalkingVisitor CREATE_CHILDREN_PSI = new RecursiveTreeElementWalkingVisitor(false){

        @Override
        public void visitLeaf(LeafElement leaf) {
        }

        @Override
        public void visitComposite(CompositeElement composite) {
            ProgressIndicatorProvider.checkCanceled();
            if (composite.myWrapper != null) {
                this.stopWalking();
                return;
            }
            composite.createAndStorePsi();
            super.visitComposite(composite);
        }
    };

    public CompositeElement(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.<init> must not be null");
        }
        super(type);
        this.firstChild = null;
        this.lastChild = null;
        this.myModificationsCount = 0;
        this.myCachedLength = -239;
        this.myHC = -1;
        this.myWrapper = null;
    }

    public int getModificationCount() {
        return this.myModificationsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        Object object = PsiLock.LOCK;
        synchronized (object) {
            clone.firstChild = null;
            clone.lastChild = null;
            clone.myModificationsCount = 0;
            clone.myWrapper = null;
            for (ASTNode child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
                clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
            }
            clone.clearCaches();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtreeChanged() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
                compositeElement.clearCaches();
                if (compositeElement instanceof PsiElement) continue;
                PsiElement psi = compositeElement.myWrapper;
                if (psi instanceof ASTDelegatePsiElement) {
                    ((ASTDelegatePsiElement)psi).subtreeChanged();
                    continue;
                }
                if (!(psi instanceof PsiFile)) continue;
                ((PsiFile)psi).subtreeChanged();
            }
        }
    }

    @Override
    public void clearCaches() {
        boolean ok;
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || Thread.holdsLock(START_OFFSET_LOCK) || this.isNonPhysicalOrInjected();
        if (!ok) {
            FileElement fileElement = TreeUtil.getFileElement(this);
            PsiFile psiFile = fileElement == null ? null : (PsiFile)fileElement.getPsi();
            LOG.error("Threading assertion.  Under write: " + ApplicationManager.getApplication().isWriteAccessAllowed() + "; Thread.holdsLock(START_OFFSET_LOCK): " + Thread.holdsLock(START_OFFSET_LOCK) + "; Thread.holdsLock(PsiLock.LOCK): " + Thread.holdsLock(PsiLock.LOCK) + "; wrapper: " + this.myWrapper + "; wrapper.isPhysical(): " + (this.myWrapper != null && this.myWrapper.isPhysical()) + "; fileElement: " + fileElement + "; psiFile: " + psiFile + "; psiFile.getViewProvider(): " + (psiFile == null ? null : psiFile.getViewProvider()) + "; psiFile.isPhysical(): " + (psiFile != null && psiFile.isPhysical()));
        }
        this.myCachedLength = -239;
        ++this.myModificationsCount;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private boolean isNonPhysicalOrInjected() {
        PsiElement wrapper;
        FileElement fileElement = TreeUtil.getFileElement(this);
        if (fileElement == null || fileElement instanceof DummyHolderElement) {
            return true;
        }
        if (fileElement.getTreeParent() != null) {
            return true;
        }
        PsiElement psiElement = wrapper = this instanceof PsiElement ? (PsiElement)((Object)this) : this.myWrapper;
        if (wrapper == null) {
            return true;
        }
        PsiFile psiFile = wrapper.getContainingFile();
        return psiFile == null || psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element = this;
        block0: while (true) {
            TreeElement child = ((TreeElement)element).getFirstChildNode();
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = child.getTreeNext();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    element = child;
                    continue block0;
                }
                offset -= textLength;
                child = child.getTreeNext();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(IElementType type) {
        ASTNode node = this.findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(TokenSet types) {
        ASTNode node = this.findChildByType(types);
        return node == null ? null : node.getPsi();
    }

    @Override
    public ASTNode findChildByType(IElementType type) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    @Override
    public ASTNode findChildByType(IElementType type, ASTNode anchor) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        ASTNode child = anchor;
        while (child != null) {
            if (type == child.getElementType()) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.findChildByType must not be null");
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.findChildByType must not be null");
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        ASTNode child = anchor;
        while (child != null) {
            if (typesSet.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = new String(this.textToCharArray());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getText must not return null");
        }
        return string;
    }

    @Override
    public CharSequence getChars() {
        return new CharArrayCharSequence(this.textToCharArray());
    }

    @Override
    public int getNotCachedLength() {
        final int[] result = new int[]{0};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof LeafElement || TreeUtil.isCollapsedChameleon(element)) {
                    result[0] = result[0] + element.getNotCachedLength();
                }
                super.visitNode(element);
            }
        });
        return result[0];
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        int endOffset;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int startStamp = this.myModificationsCount;
        int len = this.getTextLength();
        if (startStamp != this.myModificationsCount) {
            throw new AssertionError((Object)"Tree changed while calculating text");
        }
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer), startStamp);
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, endOffset), startStamp);
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.textToCharArray must not return null");
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text, int startStamp) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n changed=" + (startStamp != this.myModificationsCount);
        msg = msg + ";\n buffer=" + text;
        msg = msg + ";\n this=" + this;
        int shitStart = this.textMatches(text, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file;
                msg = msg + ";\n psi.file.tl=" + file.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                PsiElement fileLeaf = file.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    @Override
    public boolean textContains(char c) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.textMatches must not be null");
        }
        int curOffset = start;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if ((curOffset = child.textMatches(buffer, curOffset)) >= 0) continue;
            return curOffset;
        }
        return curOffset;
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this, child);
        return 0;
    }

    protected final int getChildRole(ASTNode child, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @Override
    public ASTNode[] getChildren(TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            return EMPTY_ARRAY;
        }
        ASTNode[] result = new ASTNode[count];
        count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            result[count++] = child;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(TokenSet filter, PsiElementArrayConstructor<T> constructor) {
        void var6_7;
        PsiElement[] psiElementArray;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result = constructor.newPsiElementArray(count);
        if (count == 0) {
            psiElementArray = result;
            if (result == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
            return psiElementArray;
        }
        int idx = 0;
        TreeElement treeElement = this.getFirstChildNode();
        while (var6_7 != null && idx < count) {
            if (filter == null || filter.contains(var6_7.getElementType())) {
                PsiElement element = var6_7.getPsi();
                LOG.assertTrue(element != null, var6_7);
                result[idx++] = element;
            }
            ASTNode aSTNode = var6_7.getTreeNext();
        }
        psiElementArray = result;
        if (result != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(TokenSet filter, ArrayFactory<T> constructor) {
        void var6_7;
        PsiElement[] psiElementArray;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result = (PsiElement[])constructor.create(count);
        if (count == 0) {
            psiElementArray = result;
            if (result == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
            return psiElementArray;
        }
        int idx = 0;
        TreeElement treeElement = this.getFirstChildNode();
        while (var6_7 != null && idx < count) {
            if (filter == null || filter.contains(var6_7.getElementType())) {
                PsiElement element = var6_7.getPsi();
                LOG.assertTrue(element != null, var6_7);
                result[idx++] = element;
            }
            ASTNode aSTNode = var6_7.getTreeNext();
        }
        psiElementArray = result;
        if (result != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@NotNull IElementType type, ArrayFactory<T> constructor) {
        void var6_7;
        PsiElement[] psiElementArray;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(type);
        PsiElement[] result = (PsiElement[])constructor.create(count);
        if (count == 0) {
            psiElementArray = result;
            if (result == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
            return psiElementArray;
        }
        int idx = 0;
        TreeElement treeElement = this.getFirstChildNode();
        while (var6_7 != null && idx < count) {
            if (type == var6_7.getElementType()) {
                PsiElement element = var6_7.getPsi();
                LOG.assertTrue(element != null, var6_7);
                result[idx++] = element;
            }
            ASTNode aSTNode = var6_7.getTreeNext();
        }
        psiElementArray = result;
        if (result != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
    }

    public int countChildren(TokenSet filter) {
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            ++count;
        }
        return count;
    }

    public int countChildren(IElementType type) {
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type != child.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before == null || before != false ? null : this.getFirstChildNode());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.deleteChildInternal must not be null");
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChildInternal must not be null");
        }
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChildInternal must not be null");
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        String string = START_OFFSET_LOCK;
        synchronized (string) {
            cachedLength = this.myCachedLength;
            if (cachedLength >= 0) {
                return cachedLength;
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            try {
                this.walkCachingLength();
            }
            catch (AssertionError e) {
                this.myCachedLength = -239;
                String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
                throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
            }
            return this.myCachedLength;
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    private void walkCachingLength() {
        if (this.myCachedLength != -239) {
            throw new AssertionError((Object)("Before walking: cached=" + this.myCachedLength));
        }
        TreeElement cur = this;
        while (cur != null) {
            cur = this.next(cur);
        }
        if (this.myCachedLength < 0) {
            throw new AssertionError((Object)("After walking: cached=" + this.myCachedLength));
        }
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Nullable
    private TreeElement next(TreeElement cur) {
        boolean down;
        int len = cur.getCachedLength();
        boolean bl = down = len == -239;
        if (down) {
            CompositeElement composite = (CompositeElement)cur;
            TreeElement child = composite.getFirstChildNode();
            if (child != null) {
                LOG.assertTrue(child.getTreeParent() == composite, cur);
                return child;
            }
            composite.myCachedLength = 0;
        } else assert (len >= 0) : this + "; len=" + len;
        while (cur != this) {
            CompositeElement parent = cur.getTreeParent();
            int curLength = cur.getCachedLength();
            if (curLength < 0) {
                throw new AssertionError((Object)(cur + "; " + curLength));
            }
            parent.myCachedLength -= curLength;
            TreeElement next = cur.getTreeNext();
            if (next != null) {
                LOG.assertTrue(next.getTreePrev() == cur, cur);
                return next;
            }
            LOG.assertTrue(parent.getLastChildNode() == cur, parent);
            parent.myCachedLength = -parent.myCachedLength + -239;
            cur = parent;
        }
        return null;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public void addChild(@NotNull ASTNode child, final @Nullable ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.addChild must not be null");
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, "anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last = ((TreeElement)child).getTreeNext();
        final TreeElement first = (TreeElement)child;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                if (anchorBefore != null) {
                    CompositeElement.insertBefore(destinationTreeChange, (TreeElement)anchorBefore, first);
                } else {
                    CompositeElement.add(destinationTreeChange, CompositeElement.this, first);
                }
            }
        }, this);
    }

    @Override
    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.addLeaf must not be null");
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    @Override
    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.addChild must not be null");
        }
        this.addChild(child, null);
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.removeChild must not be null");
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.removeRange must not be null");
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChild must not be null");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChild must not be null");
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        final TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        final TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                CompositeElement.replace(destinationTreeChange, oldChild1, newChild1);
                CompositeElement.repairRemovedElement(CompositeElement.this, oldChild1);
            }
        }, this);
    }

    @Override
    public void replaceAllChildrenToChildrenOf(final ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        final ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(anotherParent, ChangeInfoImpl.create((short)3, anotherParent));
                ((CompositeElement)anotherParent).rawRemoveAllChildren();
            }
        }, (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    if (CompositeElement.this.getTreeParent() != null) {
                        ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, CompositeElement.this);
                        changeInfo.setOldLength(CompositeElement.this.getTextLength());
                        destinationTreeChange.addElementaryChange(CompositeElement.this, changeInfo);
                        CompositeElement.this.rawRemoveAllChildren();
                        CompositeElement.this.rawAddChildren((TreeElement)firstChild);
                    } else {
                        TreeElement first = CompositeElement.this.getFirstChildNode();
                        CompositeElement.remove(destinationTreeChange, first, null);
                        CompositeElement.add(destinationTreeChange, CompositeElement.this, (TreeElement)firstChild);
                        CompositeElement.repairRemovedElement(CompositeElement.this, first);
                    }
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        while (firstChild != lastChild) {
            ASTNode next1 = firstChild.getTreeNext();
            this.addChild(firstChild, anchorBefore);
            firstChild = next1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            wrapper = this.myWrapper;
            if (wrapper != null) {
                return wrapper;
            }
            return this.createAndStorePsi();
        }
    }

    @Override
    @Nullable
    public <T extends PsiElement> T getPsi(Class<T> clazz) {
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    private PsiElement createAndStorePsi() {
        PsiElement psi;
        this.myWrapper = psi = this.createPsiNoLock();
        return psi;
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement(this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.setPsi must not be null");
        }
        this.myWrapper = psi;
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.rawAddChildren must not be null");
        }
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(TreeElement first) {
        TreeElement last = this.getLastChildNode();
        if (last == null) {
            first.rawRemoveUpToWithoutNotifications(null);
            this.setFirstChildNode(first);
            while (true) {
                TreeElement treeNext = first.getTreeNext();
                first.setTreeParent(this);
                if (treeNext == null) break;
                first = treeNext;
            }
            this.setLastChildNode(first);
            first.setTreeParent(this);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAllChildrenPsiIfNecessary() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.acceptTree(CREATE_CHILDREN_PSI);
        }
    }

    private static void repairRemovedElement(CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(TreeChangeEvent destinationTreeChange, CompositeElement parent, TreeElement first) {
        parent.rawAddChildren(first);
        for (TreeElement child = first; child != null; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void remove(TreeChangeEvent destinationTreeChange, TreeElement first, TreeElement last) {
        if (first != null) {
            for (TreeElement child = first; child != last && child != null; child = child.getTreeNext()) {
                destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
            }
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(TreeChangeEvent destinationTreeChange, TreeElement anchorBefore, TreeElement first) {
        anchorBefore.rawInsertBeforeMe(first);
        for (TreeElement child = first; child != anchorBefore; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void replace(TreeChangeEvent sourceTreeChange, TreeElement oldChild, TreeElement newChild) {
        oldChild.rawReplaceWithList(newChild);
        ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newChild);
        sourceTreeChange.addElementaryChange(newChild, change);
        change.setReplaced(oldChild);
    }

    private static void removeChildInner(TreeElement child) {
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(final TreeElement first, final TreeElement last) {
        final FileElement fileElement = TreeUtil.getFileElement(first);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    CompositeElement.remove(destinationTreeChange, first, last);
                    CompositeElement.repairRemovedElement((CompositeElement)fileElement, first);
                }
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }
}

