/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiComment;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;

public class AstBufferUtil {
    private AstBufferUtil() {
    }

    public static int toBuffer(@NotNull ASTNode element, @Nullable char[] buffer, int offset) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/AstBufferUtil.toBuffer must not be null");
        }
        return AstBufferUtil.toBuffer(element, buffer, offset, false);
    }

    public static int toBuffer(@NotNull ASTNode element, final @Nullable char[] buffer, int offset, final boolean skipWhitespaceAndComments) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/AstBufferUtil.toBuffer must not be null");
        }
        final int[] result = new int[]{offset};
        ((TreeElement)element).acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitLeaf(LeafElement element) {
                ProgressIndicatorProvider.checkCanceled();
                if (element instanceof ForeignLeafPsiElement || skipWhitespaceAndComments && (element instanceof PsiWhiteSpace || element instanceof PsiComment)) {
                    return;
                }
                result[0] = element.copyTo(buffer, result[0]);
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement) {
                    LazyParseableElement lpe = (LazyParseableElement)composite;
                    int lpeResult = lpe.copyTo(buffer, result[0]);
                    if (lpeResult >= 0) {
                        result[0] = lpeResult;
                        return;
                    }
                    assert (lpe.isParsed());
                }
                super.visitComposite(composite);
            }
        });
        return result[0];
    }

    public static String getTextSkippingWhitespaceComments(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/AstBufferUtil.getTextSkippingWhitespaceComments must not be null");
        }
        int length = AstBufferUtil.toBuffer(element, null, 0, true);
        char[] buffer = new char[length];
        AstBufferUtil.toBuffer(element, buffer, 0, true);
        return new String(buffer);
    }
}

