/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.text;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.text.ASTDiffBuilder;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.text.BlockSupportImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.util.diff.DiffTreeChangeBuilder;

public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    public TreeChangeEventImpl performActualPsiChange(PsiFile file) {
        ASTDiffBuilder astDiffBuilder = new ASTDiffBuilder((PsiFileImpl)file);
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file, astDiffBuilder);
        }
        file.subtreeChanged();
        return astDiffBuilder.getEvent();
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog.nodeReplaced must not be null");
        }
        if (newNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog.nodeReplaced must not be null");
        }
        if (oldNode instanceof FileElement && newNode instanceof FileElement) {
            this.appendReplaceFileElement((FileElement)oldNode, (FileElement)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    public void appendReplaceElementWithEvents(CompositeElement oldRoot, CompositeElement newRoot) {
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    public void appendReplaceFileElement(FileElement oldNode, FileElement newNode) {
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        if (oldParent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog.nodeDeleted must not be null");
        }
        if (oldNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog.nodeDeleted must not be null");
        }
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog.nodeInserted must not be null");
        }
        if (newNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog.nodeInserted must not be null");
        }
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    private static PsiElement getPsi(ASTNode node, PsiFile file) {
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, ((PsiFileImpl)file).getTreeElement());
        PsiElement psiChild = file.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    private static class ReplaceElementWithEvents
    extends LogEntry {
        private final CompositeElement myOldRoot;
        private final CompositeElement myNewRoot;

        public ReplaceElementWithEvents(CompositeElement oldRoot, CompositeElement newRoot) {
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents.doActualPsiChange must not be null");
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceElementWithEvents.doActualPsiChange must not be null");
            }
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }
    }

    private static class ReplaceFileElement
    extends LogEntry {
        private final FileElement myOldNode;
        private final FileElement myNewNode;

        public ReplaceFileElement(FileElement oldNode, FileElement newNode) {
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            TreeElement firstChildNode;
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement.doActualPsiChange must not be null");
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceFileElement.doActualPsiChange must not be null");
            }
            PsiFileImpl fileImpl = (PsiFileImpl)file;
            int oldLength = this.myOldNode.getTextLength();
            PsiManagerImpl manager = (PsiManagerImpl)fileImpl.getManager();
            BlockSupportImpl.sendBeforeChildrenChangeEvent(manager, fileImpl, false);
            if (this.myOldNode.getFirstChildNode() != null) {
                this.myOldNode.rawRemoveAllChildren();
            }
            if ((firstChildNode = this.myNewNode.getFirstChildNode()) != null) {
                this.myOldNode.rawAddChildren(firstChildNode);
            }
            fileImpl.getTreeElement().setCharTable(this.myNewNode.getCharTable());
            this.myOldNode.subtreeChanged();
            BlockSupportImpl.sendAfterChildrenChangedEvent(manager, fileImpl, oldLength, false);
        }
    }

    private static class InsertEntry
    extends LogEntry {
        private final ASTNode myOldParent;
        private final ASTNode myNewNode;
        private final int myPos;

        public InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$InsertEntry.<init> must not be null");
            }
            if (newNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$InsertEntry.<init> must not be null");
            }
            assert (oldParent instanceof CompositeElement) : oldParent;
            this.myOldParent = oldParent;
            this.myNewNode = newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$InsertEntry.doActualPsiChange must not be null");
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$InsertEntry.doActualPsiChange must not be null");
            }
            ASTNode anchor = null;
            ASTNode firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i = 0; i < this.myPos; ++i) {
                anchor = anchor == null ? firstChildNode : anchor.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file);
                ((PsiManagerEx)file.getManager()).beforeChildAddition(event);
            }
            ((TreeElement)this.myNewNode).rawRemove();
            if (anchor != null) {
                ((TreeElement)anchor).rawInsertAfterMe((TreeElement)this.myNewNode);
            } else if (firstChildNode != null) {
                ((TreeElement)firstChildNode).rawInsertBeforeMe((TreeElement)this.myNewNode);
            } else {
                ((CompositeElement)this.myOldParent).rawAddChildren((TreeElement)this.myNewNode);
            }
            astDiffBuilder.nodeInserted(this.myOldParent, this.myNewNode, this.myPos);
            ((TreeElement)this.myNewNode).clearCaches();
            ((CompositeElement)this.myOldParent).subtreeChanged();
            DebugUtil.checkTreeStructure(this.myOldParent);
        }
    }

    private static class DeleteEntry
    extends LogEntry {
        private final ASTNode myOldParent;
        private final ASTNode myOldNode;

        public DeleteEntry(ASTNode oldParent, ASTNode oldNode) {
            this.myOldParent = oldParent;
            this.myOldNode = oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiChild;
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$DeleteEntry.doActualPsiChange must not be null");
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$DeleteEntry.doActualPsiChange must not be null");
            }
            ASTNode child = this.myOldNode;
            ASTNode parent = this.myOldParent;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiChild = file.isPhysical() ? child.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file);
                ((PsiManagerEx)file.getManager()).beforeChildRemoval(event);
            }
            astDiffBuilder.nodeDeleted(parent, child);
            ((TreeElement)child).rawRemove();
            ((CompositeElement)parent).subtreeChanged();
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static class ReplaceEntry
    extends LogEntry {
        private final ASTNode myOldChild;
        private final ASTNode myNewChild;

        public ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            if (oldNode == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry.<init> must not be null");
            }
            if (newNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry.<init> must not be null");
            }
            this.myOldChild = oldNode;
            this.myNewChild = newNode;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiOldChild;
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry.doActualPsiChange must not be null");
            }
            if (astDiffBuilder == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/DiffLog$ReplaceEntry.doActualPsiChange must not be null");
            }
            ASTNode oldNode = this.myOldChild;
            ASTNode newNode = this.myNewChild;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiOldChild = file.isPhysical() ? oldNode.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file.getManager());
                event.setParent(psiParent);
                event.setFile(file);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(newNode, file);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file.getManager()).beforeChildReplacement(event);
            }
            ((TreeElement)newNode).rawRemove();
            ((TreeElement)oldNode).rawReplaceWithList((TreeElement)newNode);
            astDiffBuilder.nodeReplaced(oldNode, newNode);
            ((TreeElement)newNode).clearCaches();
            if (!(newNode instanceof FileElement)) {
                ((CompositeElement)newNode.getTreeParent()).subtreeChanged();
            }
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static abstract class LogEntry {
        protected LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull ASTDiffBuilder var2);
    }
}

