/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceRegistrar;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceService;
import org.jetbrains.jet.internal.com.intellij.util.ProcessingContext;

public abstract class ReferenceProvidersRegistry {
    public static final PsiReferenceProvider NULL_REFERENCE_PROVIDER = new PsiReferenceProvider(){

        @Override
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry$1.getReferencesByElement must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry$1.getReferencesByElement must not be null");
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry$1.getReferencesByElement must not return null");
            }
            return PsiReference.EMPTY_ARRAY;
        }
    };

    public static ReferenceProvidersRegistry getInstance() {
        return ServiceManager.getService(ReferenceProvidersRegistry.class);
    }

    public abstract PsiReferenceRegistrar getRegistrar(Language var1);

    @Deprecated
    public static PsiReference[] getReferencesFromProviders(PsiElement context, @NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getReferencesFromProviders must not be null");
        }
        return ReferenceProvidersRegistry.getReferencesFromProviders(context, PsiReferenceService.Hints.NO_HINTS);
    }

    public static PsiReference[] getReferencesFromProviders(PsiElement context, @NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistry.getReferencesFromProviders must not be null");
        }
        ProgressIndicatorProvider.checkCanceled();
        assert (context.isValid()) : "Invalid context: " + context;
        ReferenceProvidersRegistry registry = ReferenceProvidersRegistry.getInstance();
        return registry.doGetReferencesFromProviders(context, hints);
    }

    protected abstract PsiReference[] doGetReferencesFromProviders(PsiElement var1, PsiReferenceService.Hints var2);
}

