/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.conflictResolvers.JavaVariableConflictResolver;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.ConflictFilterProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class VariableResolverProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.VARIABLE;
    private boolean myStaticScopeFlag = false;
    private final PsiClass myAccessClass;
    private PsiElement myCurrentFileContext = null;

    public VariableResolverProcessor(PsiJavaCodeReferenceElement place) {
        super(place.getText(), ourFilter, new PsiConflictResolver[]{new JavaVariableConflictResolver()}, new SmartList<CandidateInfo>(), place);
        PsiElement referenceName = place.getReferenceNameElement();
        if (referenceName instanceof PsiIdentifier) {
            this.setName(referenceName.getText());
        }
        PsiClass access = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            JavaResolveResult accessClass = PsiUtil.getAccessObjectClass((PsiExpression)qualifier);
            PsiElement element = accessClass.getElement();
            if (element instanceof PsiTypeParameter) {
                PsiElementFactory factory = JavaPsiFacade.getInstance(element.getProject()).getElementFactory();
                PsiClassType type = factory.createType((PsiTypeParameter)element);
                PsiType accessType = accessClass.getSubstitutor().substitute(type);
                if (accessType instanceof PsiArrayType) {
                    LanguageLevel languageLevel = PsiUtil.getLanguageLevel(qualifier);
                    access = factory.getArrayClass(languageLevel);
                } else if (accessType instanceof PsiClassType) {
                    access = ((PsiClassType)accessType).resolve();
                }
            } else if (element instanceof PsiClass) {
                access = (PsiClass)element;
            }
        }
        this.myAccessClass = access;
    }

    @Override
    public final void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        super.handleEvent(event, associated);
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public void add(PsiElement element, PsiSubstitutor substitutor) {
        boolean staticProblem = this.myStaticScopeFlag && !((PsiModifierListOwner)element).hasModifierProperty("static");
        this.add(new CandidateInfo(element, substitutor, this.myPlace, this.myAccessClass, staticProblem, this.myCurrentFileContext));
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (!(element instanceof PsiField) && (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace))) {
            super.execute(element, state);
            return this.myResults.isEmpty();
        }
        return super.execute(element, state);
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }
}

