/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNamedElement;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.scope.BaseScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.util.containers.MostlySingularMultiMap;

public class SymbolCollectingProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private final MostlySingularMultiMap<String, ResultWithContext> myResult = new MostlySingularMultiMap();
    private PsiElement myCurrentFileContext = null;

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        PsiNamedElement named;
        String name;
        if (element instanceof PsiNamedElement && (name = (named = (PsiNamedElement)element).getName()) != null) {
            this.myResult.add(name, new ResultWithContext(named, this.myCurrentFileContext));
        }
        return true;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.CLASS || kind == ElementClassHint.DeclarationKind.PACKAGE || kind == ElementClassHint.DeclarationKind.METHOD || kind == ElementClassHint.DeclarationKind.FIELD;
    }

    public MostlySingularMultiMap<String, ResultWithContext> getResults() {
        return this.myResult;
    }

    public static class ResultWithContext {
        private final PsiNamedElement myElement;
        private final PsiElement myFileContext;

        public ResultWithContext(@NotNull PsiNamedElement element, PsiElement fileContext) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor$ResultWithContext.<init> must not be null");
            }
            this.myElement = element;
            this.myFileContext = fileContext;
        }

        @NotNull
        public PsiNamedElement getElement() {
            PsiNamedElement psiNamedElement = this.myElement;
            if (psiNamedElement == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/SymbolCollectingProcessor$ResultWithContext.getElement must not return null");
            }
            return psiNamedElement;
        }

        public PsiElement getFileContext() {
            return this.myFileContext;
        }

        public String toString() {
            return this.myElement.toString();
        }
    }
}

