/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import java.util.List;
import java.util.ListIterator;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMember;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.Domination;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.BaseScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.NameHint;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class StaticImportResolveProcessor
extends BaseScopeProcessor
implements NameHint {
    private final PsiImportStaticReferenceElement myReference;
    private final String myName;
    private final List<JavaResolveResult> myFieldResults = new SmartList<JavaResolveResult>();
    private final List<JavaResolveResult> myClassResult = new SmartList<JavaResolveResult>();
    private final List<JavaResolveResult> myResults = new SmartList<JavaResolveResult>();

    public StaticImportResolveProcessor(PsiImportStaticReferenceElement reference) {
        this.myReference = reference;
        this.myName = this.myReference.getReferenceName();
    }

    @Override
    public boolean execute(PsiElement candidate, ResolveState state) {
        if (candidate instanceof PsiMember && ((PsiModifierListOwner)candidate).hasModifierProperty("static")) {
            if (candidate instanceof PsiField) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate, this.myFieldResults)) {
                    return true;
                }
                this.myFieldResults.add(new OurResolveResult(candidate, this.myReference));
            } else if (candidate instanceof PsiClass) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate, this.myClassResult)) {
                    return true;
                }
                this.myClassResult.add(new OurResolveResult(candidate, this.myReference));
            } else {
                this.myResults.add(new OurResolveResult(candidate, this.myReference));
            }
        }
        return true;
    }

    private static boolean checkDomination(PsiMember candidate, List<JavaResolveResult> results) {
        if (results.size() > 0) {
            ListIterator<JavaResolveResult> i = results.listIterator(results.size());
            while (i.hasPrevious()) {
                Domination domination = StaticImportResolveProcessor.dominates(candidate, (PsiMember)i.previous().getElement());
                if (domination == Domination.DOMINATED_BY) {
                    return true;
                }
                if (domination != Domination.DOMINATES) continue;
                i.remove();
            }
        }
        return false;
    }

    private static Domination dominates(PsiMember member1, PsiMember member2) {
        PsiClass class1 = member1.getContainingClass();
        PsiClass class2 = member2.getContainingClass();
        if (class1 != null && class2 != null) {
            if (class1.isInheritor(class2, true)) {
                return Domination.DOMINATES;
            }
            if (class2.isInheritor(class1, true)) {
                return Domination.DOMINATED_BY;
            }
        }
        return Domination.EQUAL;
    }

    @Override
    public String getName(ResolveState state) {
        return this.myName;
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == NameHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    public JavaResolveResult[] getResults() {
        if (this.myResults.size() + this.myFieldResults.size() + this.myClassResult.size() > 1) {
            StaticImportResolveProcessor.filterInvalid(this.myResults);
            StaticImportResolveProcessor.filterInvalid(this.myFieldResults);
            StaticImportResolveProcessor.filterInvalid(this.myClassResult);
        }
        if (!this.myFieldResults.isEmpty()) {
            this.myResults.addAll(this.myFieldResults);
        }
        if (!this.myClassResult.isEmpty()) {
            this.myResults.addAll(this.myClassResult);
        }
        return this.myResults.toArray(new JavaResolveResult[this.myResults.size()]);
    }

    private static void filterInvalid(List<JavaResolveResult> resultList) {
        if (resultList.isEmpty()) {
            return;
        }
        ListIterator<JavaResolveResult> i = resultList.listIterator(resultList.size());
        while (i.hasPrevious()) {
            if (i.previous().isValidResult()) continue;
            i.remove();
        }
    }

    private static class OurResolveResult
    extends CandidateInfo {
        private final PsiImportStaticReferenceElement myReference;

        public OurResolveResult(PsiElement candidate, PsiImportStaticReferenceElement reference) {
            super(candidate, PsiSubstitutor.EMPTY);
            this.myReference = reference;
        }

        @Override
        public boolean isAccessible() {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(this.myReference.getProject()).getResolveHelper();
            PsiElement element = this.getElement();
            return element instanceof PsiMember && resolveHelper.isAccessible((PsiMember)element, this.myReference, null);
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return true;
        }
    }
}

