/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNewExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;

public class ResolveClassUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.ResolveClassUtil");

    @Nullable
    public static PsiClass resolveClass(PsiJavaCodeReferenceElement ref) {
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKind() == 6) {
            PsiElement parent = ref.getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiNewExpression)) {
                if (parent instanceof PsiJavaCodeReferenceElement) {
                    return null;
                }
                LOG.assertTrue(false);
                return null;
            }
            PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
            LOG.assertTrue(qualifier != null);
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return null;
            }
            if (!(qualifierType instanceof PsiClassType)) {
                return null;
            }
            PsiClass qualifierClass = PsiUtil.resolveClassInType(qualifierType);
            if (qualifierClass == null) {
                return null;
            }
            String name = ref.getText();
            return qualifierClass.findInnerClassByName(name, true);
        }
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (!(classNameElement instanceof PsiIdentifier)) {
            return null;
        }
        String className = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className, ref);
        PsiScopesUtil.resolveAndWalk(processor, ref, null);
        return processor.getResult().length == 1 ? (PsiClass)processor.getResult()[0].getElement() : null;
    }
}

