/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import java.lang.ref.Reference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.jet.internal.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Trinity;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPolyVariantReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.impl.AnyPsiChangeListener;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.reference.SoftReference;
import org.jetbrains.jet.internal.com.intellij.util.containers.ConcurrentWeakHashMap;
import org.jetbrains.jet.internal.com.intellij.util.messages.MessageBus;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;

public class ResolveCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.ResolveCache");
    private final Map<PsiPolyVariantReference, Reference<ResolveResult[]>>[] myPolyVariantResolveMaps = new Map[4];
    private final Map<PsiReference, Reference>[] myResolveMaps = new Map[4];
    private final AtomicInteger myClearCount = new AtomicInteger(0);
    private final RecursionGuard myGuard = RecursionManager.createGuard("resolveCache");

    public static ResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return ServiceManager.getService(project, ResolveCache.class);
    }

    public ResolveCache(@Nullable MessageBus messageBus) {
        this.myPolyVariantResolveMaps[0] = ResolveCache.createWeakMap();
        this.myPolyVariantResolveMaps[1] = ResolveCache.createWeakMap();
        this.myResolveMaps[0] = ResolveCache.createWeakMap();
        this.myResolveMaps[1] = ResolveCache.createWeakMap();
        this.myPolyVariantResolveMaps[2] = ResolveCache.createWeakMap();
        this.myPolyVariantResolveMaps[3] = ResolveCache.createWeakMap();
        this.myResolveMaps[2] = ResolveCache.createWeakMap();
        this.myResolveMaps[3] = ResolveCache.createWeakMap();
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    ResolveCache.this.clearCache(isPhysical);
                }

                @Override
                public void afterPsiChanged(boolean isPhysical) {
                }
            });
        }
    }

    private static <K, V> ConcurrentWeakHashMap<K, V> createWeakMap() {
        return new ConcurrentWeakHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), TObjectHashingStrategy.CANONICAL);
    }

    public void clearCache(boolean isPhysical) {
        this.myClearCount.incrementAndGet();
        if (isPhysical) {
            this.myPolyVariantResolveMaps[0].clear();
            this.myPolyVariantResolveMaps[1].clear();
            this.myResolveMaps[0].clear();
            this.myResolveMaps[1].clear();
        }
        this.myPolyVariantResolveMaps[2].clear();
        this.myPolyVariantResolveMaps[3].clear();
        this.myResolveMaps[2].clear();
        this.myResolveMaps[3].clear();
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(final @NotNull TRef ref, final @NotNull AbstractResolver<TRef, TResult> resolver, @NotNull Map<? super TRef, Reference<TResult>>[] maps, boolean needToPreventRecursion, final boolean incompleteCode, boolean poly) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolve must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolve must not be null");
        }
        if (maps == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolve must not be null");
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int clearCountOnStart = this.myClearCount.intValue();
        boolean physical = ref.getElement().isPhysical();
        Object result = ResolveCache.getCached(ref, maps, physical, incompleteCode);
        if (result != null) {
            return result;
        }
        Computable computable = new Computable<TResult>(){

            @Override
            public TResult compute() {
                return resolver.resolve(ref, incompleteCode);
            }
        };
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        Object object = result = needToPreventRecursion ? this.myGuard.doPreventingRecursion(Trinity.create(ref, incompleteCode, poly), true, computable) : computable.compute();
        if (stamp.mayCacheNow()) {
            this.cache(ref, result, maps, physical, incompleteCode, clearCountOnStart);
        }
        return result;
    }

    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        ResolveResult[] result = this.resolve(ref, resolver, this.myPolyVariantResolveMaps, needToPreventRecursion, incompleteCode, true);
        return result == null ? ResolveResult.EMPTY_ARRAY : result;
    }

    public PsiElement resolveWithCaching(@NotNull PsiReference ref, @NotNull Resolver resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        return this.resolve(ref, resolver, this.myResolveMaps, needToPreventRecursion, incompleteCode, false);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/ResolveCache.resolveWithCaching must not be null");
        }
        return this.resolve(ref, resolver, this.myResolveMaps, needToPreventRecursion, incompleteCode, false);
    }

    private static int getIndex(boolean physical, boolean incompleteCode) {
        return (physical ? 0 : 1) << 1 | (incompleteCode ? 1 : 0);
    }

    private static <TRef, TResult> TResult getCached(TRef ref, Map<? super TRef, Reference<TResult>>[] maps, boolean physical, boolean incompleteCode) {
        int index = ResolveCache.getIndex(physical, incompleteCode);
        Reference<TResult> reference = maps[index].get(ref);
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    private <TRef extends PsiReference, TResult> void cache(TRef ref, TResult result, Map<? super TRef, Reference<TResult>>[] maps, boolean physical, boolean incompleteCode, int clearCountOnStart) {
        if (clearCountOnStart != this.myClearCount.intValue() && result != null) {
            return;
        }
        PsiElement element = result instanceof ResolveResult ? ((ResolveResult)result).getElement() : null;
        LOG.assertTrue(element == null || element.isValid(), result);
        int index = ResolveCache.getIndex(physical, incompleteCode);
        Map<TRef, Reference<TResult>> map = maps[index];
        Reference<TResult> cached = map.get(ref);
        if (cached != null && cached.get() == result) {
            return;
        }
        map.put(ref, new SoftReference<TResult>(result));
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(TRef var1, boolean var2);
    }
}

