/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.FileResolveScopeProvider;
import org.jetbrains.jet.internal.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMember;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtil;

public class JavaResolveUtil {
    public static PsiClass getContextClass(PsiElement element) {
        for (PsiElement scope = element.getContext(); scope != null; scope = scope.getContext()) {
            if (!(scope instanceof PsiClass)) continue;
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiElement findParentContextOfClass(PsiElement element, Class aClass, boolean strict) {
        PsiElement scope;
        PsiElement psiElement = scope = strict ? element.getContext() : element;
        while (scope != null && !aClass.isInstance(scope)) {
            scope = scope.getContext();
        }
        return scope;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.isAccessible must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.isAccessible must not be null");
        }
        return JavaResolveUtil.isAccessible(member, memberClass, modifierList, place, accessObjectClass, fileResolveScope, place.getContainingFile());
    }

    public static boolean isAccessible(@NotNull PsiMember member, @Nullable PsiClass memberClass, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement fileResolveScope, PsiFile placeFile) {
        PsiClass clazz;
        PsiFile file;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.isAccessible must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.isAccessible must not be null");
        }
        if (modifierList == null) {
            return true;
        }
        PsiManager manager = member.getManager();
        if (placeFile instanceof JavaCodeFragment) {
            JavaCodeFragment fragment = (JavaCodeFragment)placeFile;
            JavaCodeFragment.VisibilityChecker visibilityChecker = fragment.getVisibilityChecker();
            if (visibilityChecker != null) {
                JavaCodeFragment.VisibilityChecker.Visibility visibility = visibilityChecker.isDeclarationVisible(member, place);
                if (visibility == JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE) {
                    return true;
                }
                if (visibility == JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE) {
                    return false;
                }
            }
        } else if (JavaResolveUtil.ignoreReferencedElementAccessibility(placeFile)) {
            return true;
        }
        if (JavaResolveUtil.isInJavaDoc(place)) {
            return true;
        }
        if (accessObjectClass != null && !JavaResolveUtil.isAccessible(accessObjectClass, accessObjectClass.getContainingClass(), accessObjectClass.getModifierList(), place, null, null, placeFile)) {
            return false;
        }
        int effectiveAccessLevel = PsiUtil.getAccessLevel(modifierList);
        PsiFile psiFile = file = placeFile == null ? null : FileContextUtil.getContextFile(placeFile);
        if (PsiImplUtil.isInServerPage(file) && PsiImplUtil.isInServerPage(member.getContainingFile())) {
            return true;
        }
        if (JavaResolveUtil.ignoreReferencedElementAccessibility(file)) {
            return true;
        }
        if (effectiveAccessLevel == 4) {
            return true;
        }
        if (effectiveAccessLevel == 3) {
            if (JavaPsiFacade.getInstance(manager.getProject()).arePackagesTheSame(member, place)) {
                return true;
            }
            if (memberClass == null) {
                return false;
            }
            for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
                if (!(placeParent instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)placeParent, memberClass, true)) continue;
                if (member instanceof PsiClass || modifierList.hasModifierProperty("static")) {
                    return true;
                }
                if (accessObjectClass != null && !InheritanceUtil.isInheritorOrSelf(accessObjectClass, (PsiClass)placeParent, true)) continue;
                return true;
            }
            return false;
        }
        if (effectiveAccessLevel == 1) {
            PsiClass topAccessClass;
            PsiClass topMemberClass;
            if (memberClass == null) {
                return true;
            }
            if (accessObjectClass != null && !manager.areElementsEquivalent(topMemberClass = JavaResolveUtil.getTopLevelClass(memberClass, accessObjectClass), topAccessClass = JavaResolveUtil.getTopLevelClass(accessObjectClass, memberClass))) {
                return false;
            }
            if (fileResolveScope == null) {
                PsiClass placeTopLevelClass = JavaResolveUtil.getTopLevelClass(place, null);
                PsiClass memberTopLevelClass = JavaResolveUtil.getTopLevelClass(memberClass, null);
                return manager.areElementsEquivalent(placeTopLevelClass, memberTopLevelClass);
            }
            return fileResolveScope instanceof PsiClass && !((PsiClass)fileResolveScope).isInheritor(memberClass, true);
        }
        if (!JavaPsiFacade.getInstance(manager.getProject()).arePackagesTheSame(member, place)) {
            return false;
        }
        if (modifierList.hasModifierProperty("static")) {
            return true;
        }
        PsiClass placeClass = JavaResolveUtil.getContextClass(place);
        if (memberClass == null || placeClass == null) {
            return true;
        }
        if (memberClass.isInterface() || placeClass.isInterface()) {
            return true;
        }
        PsiClass psiClass = clazz = accessObjectClass != null ? accessObjectClass : placeClass.getSuperClass();
        if (clazz != null && clazz.isInheritor(memberClass, true)) {
            PsiClass superClass = clazz;
            while (!manager.areElementsEquivalent(superClass, memberClass)) {
                if (superClass == null || !JavaPsiFacade.getInstance(manager.getProject()).arePackagesTheSame(superClass, memberClass)) {
                    return false;
                }
                superClass = superClass.getSuperClass();
            }
        }
        return true;
    }

    private static boolean ignoreReferencedElementAccessibility(PsiFile placeFile) {
        return placeFile instanceof FileResolveScopeProvider && ((FileResolveScopeProvider)((Object)placeFile)).ignoreReferencedElementAccessibility() && !PsiImplUtil.isInServerPage(placeFile);
    }

    public static boolean isInJavaDoc(PsiElement place) {
        for (PsiElement scope = place; scope != null; scope = scope.getContext()) {
            if (scope instanceof PsiDocComment) {
                return true;
            }
            if (!(scope instanceof PsiMember) && !(scope instanceof PsiMethodCallExpression) && !(scope instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    private static PsiClass getTopLevelClass(@NotNull PsiElement place, PsiClass memberClass) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveUtil.getTopLevelClass must not be null");
        }
        PsiClass lastClass = null;
        for (PsiElement placeParent = place; placeParent != null; placeParent = placeParent.getContext()) {
            if (!(placeParent instanceof PsiClass) || placeParent instanceof PsiAnonymousClass || placeParent instanceof PsiTypeParameter) continue;
            PsiClass aClass = (PsiClass)placeParent;
            if (memberClass != null && aClass.isInheritor(memberClass, true)) {
                return aClass;
            }
            lastClass = aClass;
        }
        return lastClass;
    }

    public static boolean processImplicitlyImportedPackages(PsiScopeProcessor processor, ResolveState state, PsiElement place, PsiManager manager) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance(manager.getProject()).findPackage("");
        if (defaultPackage != null && !defaultPackage.processDeclarations(processor, state, null, place)) {
            return false;
        }
        PsiPackage langPackage = JavaPsiFacade.getInstance(manager.getProject()).findPackage("java.lang");
        return langPackage == null || langPackage.processDeclarations(processor, state, null, place);
    }
}

