/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.Domination;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.infos.ClassCandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.scope.BaseScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.jet.internal.com.intellij.psi.scope.NameHint;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;

public class ClassResolverProcessor
extends BaseScopeProcessor
implements ElementClassHint,
NameHint {
    private static final String[] DEFAULT_PACKAGES = new String[]{"java.lang"};
    private final String myClassName;
    private final PsiElement myPlace;
    private PsiClass myAccessClass = null;
    private List<ClassCandidateInfo> myCandidates = null;
    private boolean myHasAccessibleCandidate;
    private boolean myHasInaccessibleCandidate;
    private JavaResolveResult[] myResult = JavaResolveResult.EMPTY_ARRAY;
    private PsiElement myCurrentFileContext;
    private boolean myStaticContext = false;

    public ClassResolverProcessor(String className, PsiElement place) {
        PsiType type;
        PsiReferenceExpression expression;
        PsiExpression qualifierExpression;
        this.myClassName = className;
        PsiFile file = place.getContainingFile();
        if (file instanceof JavaCodeFragment && ((JavaCodeFragment)file).getVisibilityChecker() != null) {
            place = null;
        }
        this.myPlace = place;
        if (place instanceof PsiReferenceExpression && (qualifierExpression = (expression = (PsiReferenceExpression)place).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof PsiClassType) {
            this.myAccessClass = ((PsiClassType)type).resolve();
        }
    }

    public JavaResolveResult[] getResult() {
        if (this.myResult != null) {
            return this.myResult;
        }
        if (this.myCandidates == null) {
            this.myResult = JavaResolveResult.EMPTY_ARRAY;
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (this.myHasAccessibleCandidate && this.myHasInaccessibleCandidate) {
            Iterator<ClassCandidateInfo> iterator = this.myCandidates.iterator();
            while (iterator.hasNext()) {
                CandidateInfo info = iterator.next();
                if (info.isAccessible()) continue;
                iterator.remove();
            }
            this.myHasInaccessibleCandidate = false;
        }
        this.myResult = this.myCandidates.toArray(new JavaResolveResult[this.myCandidates.size()]);
        return this.myResult;
    }

    @Override
    public String getName(ResolveState state) {
        return this.myClassName;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.CLASS;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticContext = true;
        } else if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    private static boolean isImported(PsiElement fileContext) {
        return fileContext instanceof PsiImportStatementBase;
    }

    private boolean isOnDemand(PsiElement fileContext, PsiClass psiClass) {
        if (ClassResolverProcessor.isImported(fileContext)) {
            return ((PsiImportStatementBase)fileContext).isOnDemand();
        }
        String fqn = psiClass.getQualifiedName();
        if (fqn == null) {
            return false;
        }
        PsiFile file = this.myPlace == null ? null : FileContextUtil.getContextFile(this.myPlace);
        String[] defaultPackages = file instanceof PsiJavaFile ? ((PsiJavaFile)file).getImplicitlyImportedPackages() : DEFAULT_PACKAGES;
        String packageName = StringUtil.getPackageName(fqn);
        for (String defaultPackage : defaultPackages) {
            if (!defaultPackage.equals(packageName)) continue;
            return true;
        }
        return file instanceof PsiJavaFile && ((PsiJavaFile)file).getPackageName().equals(packageName);
    }

    private Domination dominates(PsiClass aClass, boolean accessible, String fqName, ClassCandidateInfo info) {
        boolean otherDefault;
        PsiClass otherClass = info.getElement();
        assert (otherClass != null);
        String otherQName = otherClass.getQualifiedName();
        if (fqName.equals(otherQName)) {
            return Domination.DOMINATED_BY;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = otherClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null && containingClass2.isInheritor(containingClass1, true) && !ClassResolverProcessor.isImported(this.myCurrentFileContext)) {
            return Domination.DOMINATED_BY;
        }
        boolean infoAccessible = info.isAccessible();
        if (infoAccessible && !accessible) {
            return Domination.DOMINATED_BY;
        }
        if (!infoAccessible && accessible) {
            return Domination.DOMINATES;
        }
        boolean isDefault = StringUtil.getPackageName(fqName).length() == 0;
        boolean bl = otherDefault = otherQName != null && StringUtil.getPackageName(otherQName).length() == 0;
        if (isDefault && !otherDefault) {
            return Domination.DOMINATED_BY;
        }
        if (!isDefault && otherDefault) {
            return Domination.DOMINATES;
        }
        boolean myOnDemand = this.isOnDemand(this.myCurrentFileContext, aClass);
        boolean otherOnDemand = this.isOnDemand(info.getCurrentFileResolveScope(), otherClass);
        if (myOnDemand && !otherOnDemand) {
            return Domination.DOMINATED_BY;
        }
        if (!myOnDemand && otherOnDemand) {
            return Domination.DOMINATES;
        }
        return Domination.EQUAL;
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        boolean accessible;
        if (!(element instanceof PsiClass)) {
            return true;
        }
        PsiClass aClass = (PsiClass)element;
        String name = aClass.getName();
        if (!this.myClassName.equals(name)) {
            return true;
        }
        boolean bl = accessible = this.myPlace == null || this.checkAccessibility(aClass);
        if (this.myCandidates == null) {
            this.myCandidates = new SmartList<ClassCandidateInfo>();
        } else {
            String fqName = aClass.getQualifiedName();
            if (fqName != null) {
                for (int i = this.myCandidates.size() - 1; i >= 0; --i) {
                    ClassCandidateInfo info = this.myCandidates.get(i);
                    Domination domination = this.dominates(aClass, accessible, fqName, info);
                    if (domination == Domination.DOMINATED_BY) {
                        return true;
                    }
                    if (domination != Domination.DOMINATES) continue;
                    this.myCandidates.remove(i);
                }
            }
        }
        this.myHasAccessibleCandidate |= accessible;
        this.myHasInaccessibleCandidate |= !accessible;
        this.myCandidates.add(new ClassCandidateInfo((PsiElement)aClass, state.get(PsiSubstitutor.KEY), !accessible, this.myCurrentFileContext));
        this.myResult = null;
        if (!accessible) {
            return true;
        }
        return this.myCurrentFileContext instanceof PsiImportStatementBase;
    }

    private boolean checkAccessibility(PsiClass aClass) {
        PsiFile file;
        if (JavaResolveUtil.isInJavaDoc(this.myPlace)) {
            return true;
        }
        if (PsiImplUtil.isInServerPage(aClass.getContainingFile()) && PsiImplUtil.isInServerPage(file = FileContextUtil.getContextFile(this.myPlace))) {
            return true;
        }
        boolean accessible = true;
        if (aClass instanceof PsiTypeParameter) {
            accessible = !this.myStaticContext;
        }
        PsiManager manager = aClass.getManager();
        if (aClass.hasModifierProperty("private")) {
            PsiElement parentScope;
            PsiElement parent = aClass.getParent();
            while (!((parentScope = parent.getParent()) instanceof PsiJavaFile)) {
                parent = parentScope;
                if (parentScope instanceof PsiClass) continue;
                break;
            }
            if (parent instanceof PsiDeclarationStatement) {
                parent = parent.getParent();
            }
            accessible = false;
            for (PsiElement placeParent = this.myPlace; placeParent != null; placeParent = placeParent.getContext()) {
                if (!manager.areElementsEquivalent(placeParent, parent)) continue;
                accessible = true;
            }
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (aClass.hasModifierProperty("protected")) {
            accessible = false;
            if (this.myPlace != null && facade.arePackagesTheSame(aClass, this.myPlace)) {
                accessible = true;
            } else if (aClass.getContainingClass() != null) {
                boolean bl = accessible = this.myAccessClass == null || this.myPlace != null && facade.getResolveHelper().isAccessible(aClass, this.myPlace, this.myAccessClass);
            }
        }
        if (aClass.hasModifierProperty("packageLocal") && (this.myPlace == null || !facade.arePackagesTheSame(aClass, this.myPlace))) {
            accessible = false;
        }
        return accessible;
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }
}

