/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.javadoc;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiElementArrayConstructor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiInlineDocTag;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiInlineDocTagImpl
extends CompositePsiElement
implements Constants,
PsiInlineDocTag {
    private static final TokenSet TAG_VALUE_BIT_SET = TokenSet.create(DOC_TAG_VALUE_ELEMENT, DOC_METHOD_OR_FIELD_REF);
    private static final TokenSet VALUE_BIT_SET = TokenSet.orSet(TAG_VALUE_BIT_SET, TokenSet.create(JAVA_CODE_REFERENCE, DOC_TAG_VALUE_TOKEN, DOC_COMMENT_DATA, DOC_INLINE_TAG, DOC_REFERENCE_HOLDER, WHITE_SPACE, DOC_COMMENT_BAD_CHARACTER));

    public PsiInlineDocTagImpl() {
        super(DOC_INLINE_TAG);
    }

    @Override
    public PsiDocComment getContainingComment() {
        ASTNode scope = this.getTreeParent();
        while (scope.getElementType() != JavaDocElementType.DOC_COMMENT) {
            scope = scope.getTreeParent();
        }
        return (PsiDocComment)SourceTreeToPsiMap.treeElementToPsi(scope);
    }

    @Override
    public PsiElement getNameElement() {
        return this.findPsiChildByType(DOC_TAG_NAME);
    }

    @Override
    public PsiElement[] getDataElements() {
        return this.getChildrenAsPsiElements(VALUE_BIT_SET, PsiElementArrayConstructor.PSI_ELEMENT_ARRAY_CONSTRUCTOR);
    }

    @Override
    public PsiDocTagValue getValueElement() {
        return (PsiDocTagValue)this.findPsiChildByType(TAG_VALUE_BIT_SET);
    }

    @Override
    public String getName() {
        PsiElement nameElement = this.getNameElement();
        if (nameElement == null) {
            return "";
        }
        return nameElement.getText().substring(1);
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this) : child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == DOC_TAG_NAME) {
            return 105;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_INLINE_TAG_START) {
            return 108;
        }
        if (i == DOC_INLINE_TAG_END) {
            return 109;
        }
        if (TAG_VALUE_BIT_SET.contains(i)) {
            return 242;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiInlineDocTagImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitInlineDocTag(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        PsiElement nameElement = this.getNameElement();
        return "PsiInlineDocTag:" + (nameElement != null ? nameElement.getText() : null);
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiInlineDocTagImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }
}

