/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.javadoc;

import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDocCommentOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiNamedElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTarget;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocToken;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;

public class PsiDocParamRef
extends CompositePsiElement
implements PsiDocTagValue {
    public PsiDocParamRef() {
        super(JavaDocElementType.DOC_PARAMETER_REF);
    }

    @Override
    public PsiReference getReference() {
        final PsiDocComment comment = PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
        if (comment == null) {
            return null;
        }
        final PsiDocCommentOwner owner = comment.getOwner();
        if (!(owner instanceof PsiMethod) && !(owner instanceof PsiClass)) {
            return null;
        }
        final ASTNode valueToken = this.findChildByType(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        if (valueToken == null) {
            return null;
        }
        String name = valueToken.getText();
        PsiTarget reference = null;
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof PsiDocToken && ((PsiDocToken)firstChild).getTokenType().equals(JavaDocTokenType.DOC_TAG_VALUE_LT)) {
            PsiTypeParameter[] typeParameters;
            for (PsiTypeParameter typeParameter : typeParameters = ((PsiTypeParameterListOwner)((Object)owner)).getTypeParameters()) {
                if (!typeParameter.getName().equals(name)) continue;
                reference = typeParameter;
            }
        } else if (owner instanceof PsiMethod) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = ((PsiMethod)owner).getParameterList().getParameters()) {
                if (!parameter.getName().equals(name)) continue;
                reference = parameter;
            }
        }
        final PsiParameter resultReference = reference;
        return new PsiJavaReference(){

            @Override
            public PsiElement resolve() {
                return resultReference;
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                String string = valueToken.getText();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.getCanonicalText must not return null");
                }
                return string;
            }

            @Override
            public PsiElement handleElementRename(String newElementName) {
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(PsiDocParamRef.this.getNode());
                LeafElement newElement = Factory.createSingleLeafElement(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, newElementName, charTableByTree, PsiDocParamRef.this.getManager());
                PsiDocParamRef.this.replaceChild(valueToken, newElement);
                return PsiDocParamRef.this;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.bindToElement must not be null");
                }
                if (this.isReferenceTo(element)) {
                    return PsiDocParamRef.this;
                }
                if (!(element instanceof PsiParameter)) {
                    throw new IncorrectOperationException("Unsupported operation");
                }
                return this.handleElementRename(((PsiParameter)element).getName());
            }

            @Override
            public boolean isReferenceTo(PsiElement element) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                PsiNamedElement namedElement = (PsiNamedElement)element;
                if (!this.getCanonicalText().equals(namedElement.getName())) {
                    return false;
                }
                return PsiDocParamRef.this.getManager().areElementsEquivalent(this.resolve(), element);
            }

            @NotNull
            public PsiElement[] getVariants() {
                PsiElement firstChild = PsiDocParamRef.this.getFirstChild();
                HashSet<String> usedNames = new HashSet<String>();
                for (PsiDocTag tag : comment.getTags()) {
                    PsiDocTagValue valueElement;
                    if (!tag.getName().equals("param") || (valueElement = tag.getValueElement()) == null) continue;
                    usedNames.add(valueElement.getText());
                }
                PsiNamedElement[] result = PsiNamedElement.EMPTY_ARRAY;
                if (firstChild instanceof PsiDocToken && ((PsiDocToken)firstChild).getTokenType().equals(JavaDocTokenType.DOC_TAG_VALUE_LT)) {
                    result = ((PsiTypeParameterListOwner)((Object)owner)).getTypeParameters();
                } else if (owner instanceof PsiMethod) {
                    result = ((PsiMethod)owner).getParameterList().getParameters();
                }
                ArrayList<PsiNamedElement> filtered = new ArrayList<PsiNamedElement>();
                for (PsiNamedElement namedElement : result) {
                    if (usedNames.contains(namedElement.getName())) continue;
                    filtered.add(namedElement);
                }
                PsiElement[] psiElementArray = filtered.toArray(new PsiElement[filtered.size()]);
                if (psiElementArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.getVariants must not return null");
                }
                return psiElementArray;
            }

            @Override
            public boolean isSoft() {
                return false;
            }

            @Override
            public TextRange getRangeInElement() {
                int startOffsetInParent = valueToken.getPsi().getStartOffsetInParent();
                return new TextRange(startOffsetInParent, startOffsetInParent + valueToken.getTextLength());
            }

            @Override
            public PsiElement getElement() {
                return PsiDocParamRef.this;
            }

            @Override
            public void processVariants(PsiScopeProcessor processor) {
                for (PsiElement element : this.getVariants()) {
                    if (processor.execute(element, ResolveState.initial())) continue;
                    return;
                }
            }

            @Override
            @NotNull
            public JavaResolveResult advancedResolve(boolean incompleteCode) {
                JavaResolveResult javaResolveResult = resultReference == null ? JavaResolveResult.EMPTY : new CandidateInfo(resultReference, PsiSubstitutor.EMPTY);
                if (javaResolveResult == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.advancedResolve must not return null");
                }
                return javaResolveResult;
            }

            @Override
            @NotNull
            public JavaResolveResult[] multiResolve(boolean incompleteCode) {
                JavaResolveResult[] javaResolveResultArray;
                if (resultReference == null) {
                    javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                } else {
                    JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                    javaResolveResultArray = javaResolveResultArray2;
                    javaResolveResultArray2[0] = new CandidateInfo(resultReference, PsiSubstitutor.EMPTY);
                }
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocParamRef$1.multiResolve must not return null");
                }
                return javaResolveResultArray;
            }
        };
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocParamRef.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTagValue(this);
        } else {
            visitor.visitElement(this);
        }
    }
}

