/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.javadoc;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaResolveResult;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiComment;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFactory;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiJavaReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiKeyword;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiVariable;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.jet.internal.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;

public class PsiDocMethodOrFieldRef
extends CompositePsiElement
implements Constants,
PsiDocTagValue {
    public PsiDocMethodOrFieldRef() {
        super(DOC_METHOD_OR_FIELD_REF);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTagValue(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiClass scope = this.getScope();
        PsiElement element = this.getNameElement();
        if (scope == null || element == null) {
            return new MyReference(null);
        }
        PsiReference psiReference = this.getReferenceInScope(scope, element);
        if (psiReference != null) {
            return psiReference;
        }
        PsiClass containingClass = scope.getContainingClass();
        while (containingClass != null) {
            PsiClass classScope = containingClass;
            psiReference = this.getReferenceInScope(classScope, element);
            if (psiReference != null) {
                return psiReference;
            }
            containingClass = classScope.getContainingClass();
        }
        return new MyReference(null);
    }

    @Nullable
    private PsiReference getReferenceInScope(PsiClass scope, PsiElement element) {
        PsiMethod[] methods;
        MethodSignature methodSignature;
        final String name = element.getText();
        String[] signature = this.getSignature();
        if (signature == null) {
            PsiVariable[] vars;
            for (PsiVariable var : vars = PsiDocMethodOrFieldRef.getAllVariables(scope, this)) {
                if (!var.getName().equals(name)) continue;
                return new MyReference(var);
            }
        }
        if (signature != null) {
            ArrayList<PsiType> types = Lists.newArrayListWithCapacity(signature.length);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(element.getProject()).getElementFactory();
            for (String s : signature) {
                try {
                    types.add(elementFactory.createTypeFromText(s, element));
                }
                catch (IncorrectOperationException e) {
                    types.add(PsiType.NULL);
                }
            }
            methodSignature = MethodSignatureUtil.createMethodSignature(name, types.toArray(new PsiType[types.size()]), PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, name.equals(scope.getName()));
        } else {
            methodSignature = null;
        }
        for (PsiMethod method : methods = PsiDocMethodOrFieldRef.getAllMethods(scope, this)) {
            if (!method.getName().equals(name) || methodSignature != null && !MethodSignatureUtil.areSignaturesErasureEqual(methodSignature, method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return new MyReference(method){

                @Override
                @NotNull
                public PsiElement[] getVariants() {
                    ArrayList<PsiMethod> lst = new ArrayList<PsiMethod>();
                    for (PsiMethod method : methods) {
                        if (!name.equals(method.getName())) continue;
                        lst.add(method);
                    }
                    PsiElement[] psiElementArray = lst.toArray(new PsiMethod[lst.size()]);
                    if (psiElementArray == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$1.getVariants must not return null");
                    }
                    return psiElementArray;
                }
            };
        }
        return null;
    }

    public static PsiVariable[] getAllVariables(PsiElement scope, PsiElement place) {
        SmartList result = new SmartList();
        scope.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.VARIABLE, result), ResolveState.initial(), null, place);
        return result.toArray(new PsiVariable[result.size()]);
    }

    public static PsiMethod[] getAllMethods(PsiElement scope, PsiElement place) {
        SmartList result = new SmartList();
        scope.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, result), ResolveState.initial(), null, place);
        return result.toArray(new PsiMethod[result.size()]);
    }

    @Override
    public int getTextOffset() {
        PsiElement element = this.getNameElement();
        return element != null ? element.getTextRange().getStartOffset() : this.getTextRange().getEndOffset();
    }

    @Nullable
    public PsiElement getNameElement() {
        ASTNode sharp = this.findChildByType(DOC_TAG_VALUE_SHARP_TOKEN);
        return sharp != null ? SourceTreeToPsiMap.treeToPsiNotNull(sharp).getNextSibling() : null;
    }

    @Nullable
    public String[] getSignature() {
        PsiElement element = this.getNameElement();
        if (element == null) {
            return null;
        }
        for (element = element.getNextSibling(); element != null && !(element instanceof PsiDocTagValue); element = element.getNextSibling()) {
        }
        if (element == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String[] typeStrings;
            if (child.getNode().getElementType() != DOC_TYPE_HOLDER || (typeStrings = child.getText().split("[, ]")) == null) continue;
            for (String type : typeStrings) {
                if (type.length() <= 0) continue;
                types.add(type);
            }
        }
        return ArrayUtil.toStringArray(types);
    }

    @Nullable
    private PsiClass getScope() {
        if (this.getFirstChildNode().getElementType() == ElementType.DOC_REFERENCE_HOLDER) {
            PsiElement firstChildPsi = SourceTreeToPsiMap.treeElementToPsi(this.getFirstChildNode().getFirstChildNode());
            if (firstChildPsi instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)firstChildPsi;
                PsiElement referencedElement = referenceElement.resolve();
                if (referencedElement instanceof PsiClass) {
                    return (PsiClass)referencedElement;
                }
                return null;
            }
            if (firstChildPsi instanceof PsiKeyword) {
                PsiKeyword keyword = (PsiKeyword)firstChildPsi;
                if (keyword.getTokenType().equals(THIS_KEYWORD)) {
                    return JavaResolveUtil.getContextClass(this);
                }
                if (keyword.getTokenType().equals(SUPER_KEYWORD)) {
                    PsiClass contextClass = JavaResolveUtil.getContextClass(this);
                    if (contextClass != null) {
                        return contextClass.getSuperClass();
                    }
                    return null;
                }
            }
        }
        return JavaResolveUtil.getContextClass(this);
    }

    public class MyReference
    implements PsiJavaReference {
        private final PsiElement myReferredElement;

        public MyReference(PsiElement referredElement) {
            this.myReferredElement = referredElement;
        }

        @Override
        public PsiElement resolve() {
            return this.myReferredElement;
        }

        @Override
        public void processVariants(PsiScopeProcessor processor) {
            for (PsiElement element : this.getVariants()) {
                if (processor.execute(element, ResolveState.initial())) continue;
                return;
            }
        }

        @Override
        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            JavaResolveResult javaResolveResult = this.myReferredElement == null ? JavaResolveResult.EMPTY : new CandidateInfo(this.myReferredElement, PsiSubstitutor.EMPTY);
            if (javaResolveResult == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.advancedResolve must not return null");
            }
            return javaResolveResult;
        }

        @Override
        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (this.myReferredElement == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = new CandidateInfo(this.myReferredElement, PsiSubstitutor.EMPTY);
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.multiResolve must not return null");
            }
            return javaResolveResultArray;
        }

        @NotNull
        public PsiElement[] getVariants() {
            ArrayList vars = new ArrayList();
            PsiClass scope = PsiDocMethodOrFieldRef.this.getScope();
            if (scope != null) {
                ContainerUtil.addAll(vars, PsiDocMethodOrFieldRef.getAllMethods(scope, PsiDocMethodOrFieldRef.this));
                ContainerUtil.addAll(vars, PsiDocMethodOrFieldRef.getAllVariables(scope, PsiDocMethodOrFieldRef.this));
            }
            PsiElement[] psiElementArray = vars.toArray(new PsiModifierListOwner[vars.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.getVariants must not return null");
            }
            return psiElementArray;
        }

        @Override
        public boolean isSoft() {
            return false;
        }

        @Override
        @NotNull
        public String getCanonicalText() {
            PsiElement nameElement = PsiDocMethodOrFieldRef.this.getNameElement();
            assert (nameElement != null);
            String string = nameElement.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.getCanonicalText must not return null");
            }
            return string;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiElement nameElement = PsiDocMethodOrFieldRef.this.getNameElement();
            assert (nameElement != null);
            TreeElement treeElement = SourceTreeToPsiMap.psiToTreeNotNull(nameElement);
            CharTable charTableByTree = SharedImplUtil.findCharTableByTree(treeElement);
            LeafElement newToken = Factory.createSingleLeafElement(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, newElementName, charTableByTree, PsiDocMethodOrFieldRef.this.getManager());
            ((CompositeElement)treeElement.getTreeParent()).replaceChildInternal(SourceTreeToPsiMap.psiToTreeNotNull(nameElement), newToken);
            return SourceTreeToPsiMap.treeToPsiNotNull(newToken);
        }

        @Override
        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String newName;
            PsiClass containingClass;
            boolean hasSignature;
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.bindToElement must not be null");
            }
            if (this.isReferenceTo(element)) {
                return PsiDocMethodOrFieldRef.this;
            }
            PsiElement nameElement = PsiDocMethodOrFieldRef.this.getNameElement();
            assert (nameElement != null);
            String name = nameElement.getText();
            if (element instanceof PsiMethod) {
                method = (PsiMethod)element;
                hasSignature = PsiDocMethodOrFieldRef.this.getSignature() != null;
                containingClass = method.getContainingClass();
                newName = method.getName();
            } else if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                hasSignature = false;
                containingClass = field.getContainingClass();
                method = null;
                newName = field.getName();
            } else {
                throw new IncorrectOperationException();
            }
            PsiElement child = PsiDocMethodOrFieldRef.this.getFirstChild();
            if (containingClass != null && child != null && child.getNode().getElementType() == ElementType.DOC_REFERENCE_HOLDER) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)child.getFirstChild();
                assert (referenceElement != null);
                referenceElement.bindToElement(containingClass);
            } else if (containingClass != null && !PsiTreeUtil.isAncestor(containingClass, PsiDocMethodOrFieldRef.this, true)) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance(containingClass.getProject()).getElementFactory();
                PsiReferenceExpression ref = elementFactory.createReferenceExpression(containingClass);
                PsiDocMethodOrFieldRef.this.addAfter(ref, null);
            }
            if (hasSignature || !name.equals(newName)) {
                String text = PsiDocMethodOrFieldRef.this.getText();
                StringBuffer newText = new StringBuffer();
                newText.append("/** @see ");
                if (name.equals(newName)) {
                    newText.append(text.substring(0, text.indexOf(40)));
                } else {
                    int sharpIndex = text.indexOf(35);
                    if (sharpIndex >= 0) {
                        newText.append(text.substring(0, sharpIndex + 1));
                    }
                    newText.append(newName);
                }
                if (hasSignature) {
                    newText.append('(');
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiParameter parameter = parameters[i];
                        if (i > 0) {
                            newText.append(",");
                        }
                        newText.append(parameter.getType().getCanonicalText());
                    }
                    newText.append(')');
                }
                newText.append("*/");
                return this.bindToText(containingClass, newText);
            }
            return PsiDocMethodOrFieldRef.this;
        }

        public PsiElement bindToText(PsiClass containingClass, StringBuffer newText) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(containingClass.getProject()).getElementFactory();
            PsiComment comment = elementFactory.createCommentFromText(newText.toString(), null);
            PsiDocTag tag = PsiTreeUtil.getChildOfType(comment, PsiDocTag.class);
            PsiDocMethodOrFieldRef ref = PsiTreeUtil.getChildOfType(tag, PsiDocMethodOrFieldRef.class);
            assert (ref != null) : newText;
            return PsiDocMethodOrFieldRef.this.replace(ref);
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            return PsiDocMethodOrFieldRef.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @Override
        public TextRange getRangeInElement() {
            ASTNode sharp = PsiDocMethodOrFieldRef.this.findChildByType(JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN);
            if (sharp == null) {
                return new TextRange(0, PsiDocMethodOrFieldRef.this.getTextLength());
            }
            PsiElement nextSibling = SourceTreeToPsiMap.treeToPsiNotNull(sharp).getNextSibling();
            if (nextSibling != null) {
                int startOffset = nextSibling.getTextRange().getStartOffset() - PsiDocMethodOrFieldRef.this.getTextRange().getStartOffset();
                int endOffset = nextSibling.getTextRange().getEndOffset() - PsiDocMethodOrFieldRef.this.getTextRange().getStartOffset();
                PsiElement nextParSibling = nextSibling.getNextSibling();
                if (nextParSibling != null && "(".equals(nextParSibling.getText())) {
                    ++endOffset;
                    PsiElement nextElement = nextParSibling.getNextSibling();
                    if (nextElement != null && SourceTreeToPsiMap.psiToTreeNotNull(nextElement).getElementType() == JavaDocElementType.DOC_TAG_VALUE_ELEMENT) {
                        endOffset += nextElement.getTextLength();
                        nextElement = nextElement.getNextSibling();
                    }
                    if (nextElement != null && ")".equals(nextElement.getText())) {
                        ++endOffset;
                    }
                }
                return new TextRange(startOffset, endOffset);
            }
            return new TextRange(PsiDocMethodOrFieldRef.this.getTextLength(), PsiDocMethodOrFieldRef.this.getTextLength());
        }

        @Override
        public PsiElement getElement() {
            return PsiDocMethodOrFieldRef.this;
        }
    }
}

