/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.javadoc;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDocCommentOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.Constants;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiElementArrayConstructor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.jet.internal.com.intellij.util.CharTable;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayUtil;

public class PsiDocCommentImpl
extends LazyParseablePsiElement
implements JavaTokenType,
Constants,
PsiDocComment {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.javadoc.PsiDocCommentImpl");
    private static final TokenSet TAG_BIT_SET = TokenSet.create(DOC_TAG);
    private static final PsiElementArrayConstructor<PsiDocTag> PSI_TAG_ARRAY_CONSTRUCTOR = new PsiElementArrayConstructor<PsiDocTag>(){

        public PsiDocTag[] newPsiElementArray(int length) {
            return length == 0 ? PsiDocTag.EMPTY_ARRAY : new PsiDocTag[length];
        }
    };
    private static final Pattern WS_PATTERN = Pattern.compile("\\s*");

    public PsiDocCommentImpl(CharSequence text) {
        super(JavaDocElementType.DOC_COMMENT, text);
    }

    @Override
    public PsiDocCommentOwner getOwner() {
        PsiDocCommentOwner owner;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiDocCommentOwner && (owner = (PsiDocCommentOwner)parent).getDocComment() == this) {
            return owner;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement[] getDescriptionElements() {
        IElementType i;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode child = this.getFirstChildNode(); child != null && (i = child.getElementType()) != DOC_TAG; child = child.getTreeNext()) {
            if (i == DOC_COMMENT_START || i == DOC_COMMENT_END || i == DOC_COMMENT_LEADING_ASTERISKS) continue;
            array.add(child.getPsi());
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.getDescriptionElements must not return null");
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiDocTag[] getTags() {
        PsiDocTag[] psiDocTagArray = (PsiDocTag[])this.getChildrenAsPsiElements(TAG_BIT_SET, PSI_TAG_ARRAY_CONSTRUCTOR);
        if (psiDocTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.getTags must not return null");
        }
        return psiDocTagArray;
    }

    @Override
    public PsiDocTag findTagByName(String name) {
        if (this.getFirstChildNode().getElementType() == JavaDocElementType.DOC_COMMENT && this.getFirstChildNode().getText().indexOf(name) < 0) {
            return null;
        }
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiDocTag tag;
            CharSequence nameText;
            if (child.getElementType() != DOC_TAG || (nameText = ((LeafElement)((Object)(tag = (PsiDocTag)SourceTreeToPsiMap.treeElementToPsi(child)).getNameElement())).getChars()).length() <= 0 || nameText.charAt(0) != '@' || !CharArrayUtil.regionMatches(nameText, 1, name)) continue;
            return tag;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiDocTag[] findTagsByName(String name) {
        ArrayList<PsiDocTag> array = new ArrayList<PsiDocTag>();
        PsiDocTag[] tags = this.getTags();
        name = "@" + name;
        for (PsiDocTag tag : tags) {
            if (!tag.getNameElement().getText().equals(name)) continue;
            array.add(tag);
        }
        PsiDocTag[] psiDocTagArray = array.toArray(new PsiDocTag[array.size()]);
        if (psiDocTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.findTagsByName must not return null");
        }
        return psiDocTagArray;
    }

    @Override
    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 110: {
                return this.getFirstChildNode();
            }
            case 111: 
        }
        if (this.getLastChildNode().getElementType() == DOC_COMMENT_END) {
            return this.getLastChildNode();
        }
        return null;
    }

    private static boolean isWhitespaceCommentData(ASTNode docCommentData) {
        return WS_PATTERN.matcher(docCommentData.getText()).matches();
    }

    private static void addNewLineToTag(CompositeElement tag, Project project) {
        ASTNode current;
        LOG.assertTrue(tag != null && tag.getElementType() == DOC_TAG);
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA && PsiDocCommentImpl.isWhitespaceCommentData(current); current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            return;
        }
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(tag);
        LeafElement newLine = Factory.createSingleLeafElement(DOC_COMMENT_DATA, "\n", 0, 1, treeCharTab, SharedImplUtil.getManagerByTree(tag));
        tag.addChild(newLine, null);
        TreeElement leadingWhitespaceAnchor = null;
        if (JavaCodeStyleSettingsFacade.getInstance(project).isJavaDocLeadingAsterisksEnabled()) {
            LeafElement leadingAsterisk = Factory.createSingleLeafElement(DOC_COMMENT_LEADING_ASTERISKS, "*", 0, 1, treeCharTab, SharedImplUtil.getManagerByTree(tag));
            leadingWhitespaceAnchor = tag.addInternal(leadingAsterisk, leadingAsterisk, null, Boolean.TRUE);
        }
        LeafElement commentData = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", 0, 1, treeCharTab, SharedImplUtil.getManagerByTree(tag));
        tag.addInternal(commentData, commentData, leadingWhitespaceAnchor, Boolean.TRUE);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        boolean needToAddNewline = false;
        if (first == last && first.getElementType() == DOC_TAG) {
            if (anchor == null) {
                anchor = this.getLastChildNode();
                ASTNode prevBeforeWS = TreeUtil.skipElementsBack(anchor.getTreePrev(), ElementType.JAVA_WHITESPACE_BIT_SET);
                if (prevBeforeWS != null) {
                    anchor = prevBeforeWS;
                    before = Boolean.FALSE;
                } else {
                    before = Boolean.TRUE;
                }
                needToAddNewline = true;
            }
            if (anchor.getElementType() != DOC_TAG) {
                CharTable charTable = SharedImplUtil.findCharTableByTree(this);
                LeafElement newLine = Factory.createSingleLeafElement(DOC_COMMENT_DATA, "\n", 0, 1, charTable, this.getManager());
                LeafElement leadingAsterisk = Factory.createSingleLeafElement(DOC_COMMENT_LEADING_ASTERISKS, "*", 0, 1, charTable, this.getManager());
                LeafElement commentData = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", 0, 1, charTable, this.getManager());
                LeafElement indentWS = Factory.createSingleLeafElement(DOC_COMMENT_DATA, " ", 0, 1, charTable, this.getManager());
                newLine.getTreeParent().addChild(indentWS);
                newLine.getTreeParent().addChild(leadingAsterisk);
                newLine.getTreeParent().addChild(commentData);
                super.addInternal(newLine, commentData, anchor, Boolean.FALSE);
                anchor = commentData;
                before = Boolean.FALSE;
            } else {
                needToAddNewline = true;
            }
        }
        if (before.booleanValue()) {
            anchor.getTreeParent().addChildren(first, last.getTreeNext(), anchor);
        } else {
            anchor.getTreeParent().addChildren(first, last.getTreeNext(), anchor.getTreeNext());
        }
        if (needToAddNewline) {
            if (first.getTreePrev() != null && first.getTreePrev().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first.getTreePrev(), this.getProject());
            }
            if (first.getTreeNext() != null && first.getTreeNext().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first, this.getProject());
            } else {
                PsiDocCommentImpl.removeEndingAsterisksFromTag((CompositeElement)first);
            }
        }
        return first;
    }

    private static void removeEndingAsterisksFromTag(CompositeElement tag) {
        ASTNode current;
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA; current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            ASTNode prevWhiteSpace = TreeUtil.skipElementsBack(current.getTreePrev(), ElementType.JAVA_WHITESPACE_BIT_SET);
            ASTNode toBeDeleted = prevWhiteSpace.getTreeNext();
            while (toBeDeleted != null) {
                ASTNode next = toBeDeleted.getTreeNext();
                tag.deleteChildInternal(toBeDeleted);
                toBeDeleted = next;
            }
        }
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.deleteChildInternal must not be null");
        }
        if (child.getElementType() == DOC_TAG && (child.getTreeNext() == null || child.getTreeNext().getElementType() != DOC_TAG)) {
            ASTNode next;
            ASTNode prev;
            for (prev = child.getTreePrev(); prev != null && prev.getElementType() == DOC_COMMENT_DATA; prev = prev.getTreePrev()) {
            }
            for (next = child.getTreeNext(); next != null && (next.getElementType() == DOC_COMMENT_DATA || next.getElementType() == WHITE_SPACE); next = next.getTreeNext()) {
            }
            if (prev != null && prev.getElementType() == DOC_COMMENT_LEADING_ASTERISKS && !(next instanceof PsiDocTag)) {
                ASTNode leadingAsterisk = prev;
                if (leadingAsterisk.getTreePrev() != null) {
                    super.deleteChildInternal(leadingAsterisk.getTreePrev());
                    super.deleteChildInternal(leadingAsterisk);
                }
            } else if (prev != null && prev.getElementType() == DOC_TAG) {
                ASTNode prevChild;
                CompositeElement compositePrev = (CompositeElement)prev;
                TreeElement lastPrevChild = compositePrev.getLastChildNode();
                for (prevChild = lastPrevChild; prevChild != null && prevChild.getElementType() == DOC_COMMENT_DATA; prevChild = prevChild.getTreePrev()) {
                }
                if (prevChild != null && prevChild.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
                    ASTNode current = prevChild;
                    while (current != null) {
                        ASTNode nextChild = current.getTreeNext();
                        compositePrev.deleteChildInternal(current);
                        current = nextChild;
                    }
                }
            } else {
                next = child.getTreeNext();
                if (next != null && next.getElementType() == WHITE_SPACE) {
                    next.getTreeParent().removeChild(next);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == DOC_TAG) {
            return 104;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_COMMENT_LEADING_ASTERISKS) {
            return 107;
        }
        if (i == DOC_COMMENT_START) {
            return 110;
        }
        if (i == DOC_COMMENT_END) {
            return 111;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocComment(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiDocComment";
    }
}

