/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTFactory;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.lang.Language;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.jet.internal.com.intellij.lang.LanguageTokenSeparatorGenerators;
import org.jetbrains.jet.internal.com.intellij.lang.ParserDefinition;
import org.jetbrains.jet.internal.com.intellij.lang.TokenSeparatorGenerator;
import org.jetbrains.jet.internal.com.intellij.openapi.command.AbnormalCommandTerminationException;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.TokenType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.IndentHelper;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.RecursiveTreeElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.jet.internal.com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.jet.internal.com.intellij.util.text.CharArrayUtil;

public class CodeEditUtil {
    private static final Key<Boolean> GENERATED_FLAG = new Key("GENERATED_FLAG");
    private static final Key<Integer> INDENT_INFO = new Key("INDENT_INFO");
    private static final Key<Boolean> REFORMAT_BEFORE_KEY = new Key("REFORMAT_BEFORE_KEY");
    private static final Key<Boolean> REFORMAT_KEY = new Key("REFORMAT_KEY");
    private static final Key<Boolean> DISABLE_POSTPONED_REFORMAT_KEY = new Key("DISABLE_POSTPONED_REFORMAT_KEY");
    private static final ThreadLocal<Boolean> ALLOW_TO_MARK_NODES_TO_REFORMAT = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static final ThreadLocal<Boolean> ALLOW_NODES_REFORMATTING = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    public static final Key<Boolean> OUTER_OK = new Key("OUTER_OK");

    private CodeEditUtil() {
    }

    public static void addChild(ASTNode parent, ASTNode child, ASTNode anchorBefore) {
        CodeEditUtil.addChildren(parent, child, child, anchorBefore);
    }

    public static void removeChild(ASTNode parent, @NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.removeChild must not be null");
        }
        CodeEditUtil.removeChildren(parent, child, child);
    }

    public static ASTNode addChildren(ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last, ASTNode anchorBefore) {
        ASTNode anchorPrev;
        if (first == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.addChildren must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.addChildren must not be null");
        }
        ASTNode lastChild = last.getTreeNext();
        for (ASTNode current = first; current != lastChild; current = current.getTreeNext()) {
            CodeEditUtil.saveWhitespacesInfo(current);
            CodeEditUtil.checkForOuters(current);
        }
        if (anchorBefore != null && CodeEditUtil.isComment(anchorBefore.getElementType()) && (anchorPrev = anchorBefore.getTreePrev()) != null && anchorPrev.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorPrev;
        }
        parent.addChildren(first, lastChild, anchorBefore);
        ASTNode firstAddedLeaf = CodeEditUtil.findFirstLeaf(first, last);
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        if (firstAddedLeaf != null) {
            ASTNode lastAddedLeaf;
            ASTNode placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, firstAddedLeaf, CodeEditUtil.isFormattingRequiered(prevLeaf, first), false);
            if (placeHolderEnd != prevLeaf && first == firstAddedLeaf) {
                first = placeHolderEnd;
            }
            if ((placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(lastAddedLeaf = CodeEditUtil.findLastLeaf(first, last), TreeUtil.nextLeaf(last), true, false)) != lastAddedLeaf && lastAddedLeaf == first) {
                first = placeHolderEnd;
            }
        } else {
            CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, TreeUtil.nextLeaf(last), CodeEditUtil.isFormattingRequiered(prevLeaf, first), false);
        }
        return first;
    }

    private static boolean isComment(IElementType type) {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage());
        return def != null && def.getCommentTokens().contains(type);
    }

    private static boolean isFormattingRequiered(ASTNode prevLeaf, ASTNode first) {
        while (first != null) {
            for (ASTNode current = prevLeaf; current != null; current = current.getTreeParent()) {
                if (current.getTreeNext() != first) continue;
                return true;
            }
            ASTNode parent = first.getTreeParent();
            if (parent == null || !parent.getTextRange().equals(first.getTextRange())) break;
            first = parent;
        }
        return false;
    }

    public static void checkForOuters(ASTNode element) {
        if (element instanceof OuterLanguageElement && element.getCopyableUserData(OUTER_OK) == null) {
            throw new AbnormalCommandTerminationException();
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            CodeEditUtil.checkForOuters(child);
        }
    }

    public static void saveWhitespacesInfo(ASTNode first) {
        if (first == null || CodeEditUtil.isNodeGenerated(first) || CodeEditUtil.getOldIndentation(first) >= 0) {
            return;
        }
        PsiElement psiElement = first.getPsi();
        if (psiElement == null) {
            return;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)first, IndentHelper.getInstance().getIndent(containingFile.getProject(), containingFile.getFileType(), first));
    }

    public static int getOldIndentation(ASTNode node) {
        if (node == null) {
            return -1;
        }
        Integer stored = node.getCopyableUserData(INDENT_INFO);
        return stored != null ? stored : -1;
    }

    public static void removeChildren(ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.removeChildren must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.removeChildren must not be null");
        }
        boolean tailingElement = last.getStartOffset() + last.getTextLength() == parent.getStartOffset() + parent.getTextLength();
        boolean forceReformat = CodeEditUtil.needToForceReformat(parent, first, last);
        CodeEditUtil.saveWhitespacesInfo(first);
        for (TreeElement child = (TreeElement)first; child != null && child != last; child = child.getTreeNext()) {
        }
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        ASTNode nextLeaf = TreeUtil.nextLeaf(first);
        parent.removeRange(first, last.getTreeNext());
        ASTNode nextLeafToAdjust = nextLeaf;
        if (nextLeafToAdjust != null && prevLeaf != null && nextLeafToAdjust.getTreeParent() == null) {
            nextLeafToAdjust = prevLeaf.getTreeNext();
        }
        CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, nextLeafToAdjust, forceReformat, tailingElement);
    }

    private static boolean needToForceReformat(ASTNode parent, ASTNode first, ASTNode last) {
        return parent == null || first.getStartOffset() != parent.getStartOffset() || parent.getText().trim().length() == CodeEditUtil.getTrimmedTextLength(first, last) && CodeEditUtil.needToForceReformat(parent.getTreeParent(), parent, parent);
    }

    private static int getTrimmedTextLength(ASTNode first, ASTNode last) {
        StringBuilder buffer = new StringBuilder();
        while (first != last.getTreeNext()) {
            buffer.append(first.getText());
            first = first.getTreeNext();
        }
        return buffer.toString().trim().length();
    }

    public static void replaceChild(ASTNode parent, @NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.replaceChild must not be null");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.replaceChild must not be null");
        }
        CodeEditUtil.saveWhitespacesInfo(oldChild);
        CodeEditUtil.saveWhitespacesInfo(newChild);
        CodeEditUtil.checkForOuters(oldChild);
        CodeEditUtil.checkForOuters(newChild);
        LeafElement oldFirst = TreeUtil.findFirstLeaf(oldChild);
        parent.replaceChild(oldChild, newChild);
        LeafElement firstLeaf = TreeUtil.findFirstLeaf(newChild);
        ASTNode prevToken = TreeUtil.prevLeaf(newChild);
        if (firstLeaf != null) {
            ASTNode nextLeaf = TreeUtil.nextLeaf(newChild);
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, firstLeaf, CodeEditUtil.isFormattingRequiered(prevToken, newChild), false);
            if (nextLeaf != null && !CharArrayUtil.containLineBreaks(nextLeaf.getText())) {
                CodeEditUtil.makePlaceHolderBetweenTokens(TreeUtil.prevLeaf(nextLeaf), nextLeaf, false, false);
            }
        } else {
            ASTNode whitespaceNode;
            if (oldFirst != null && prevToken == null && (whitespaceNode = newChild.getTreeNext()) != null && whitespaceNode.getElementType() == TokenType.WHITE_SPACE) {
                parent.removeChild(whitespaceNode);
            }
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, TreeUtil.nextLeaf(newChild), CodeEditUtil.isFormattingRequiered(prevToken, newChild), false);
        }
    }

    @Nullable
    private static ASTNode findFirstLeaf(ASTNode first, ASTNode last) {
        do {
            LeafElement leaf;
            if ((leaf = TreeUtil.findFirstLeaf(first)) != null) {
                return leaf;
            }
            if ((first = first.getTreeNext()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode findLastLeaf(ASTNode first, ASTNode last) {
        do {
            ASTNode leaf;
            if ((leaf = TreeUtil.findLastLeaf(last)) != null) {
                return leaf;
            }
            if ((last = last.getTreePrev()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode makePlaceHolderBetweenTokens(ASTNode left, ASTNode right, boolean forceReformat, boolean normalizeTailingWhitespace) {
        if (right == null) {
            return left;
        }
        CodeEditUtil.markToReformatBefore(right, false);
        if (left == null) {
            CodeEditUtil.markToReformatBefore(right, true);
        } else if (left.getElementType() == TokenType.WHITE_SPACE && left.getTreeNext() == null && normalizeTailingWhitespace) {
            ASTNode prevLeaf = TreeUtil.prevLeaf(left);
            left.getTreeParent().removeChild(left);
            CodeEditUtil.markToReformatBeforeOrInsertWhitespace(prevLeaf, right);
            left = right;
        } else if (left.getElementType() == TokenType.WHITE_SPACE && right.getElementType() == TokenType.WHITE_SPACE) {
            int rightBlankLines;
            boolean leaveRightText;
            int leftBlankLines = CodeEditUtil.getBlankLines(left.getText());
            boolean bl = leaveRightText = leftBlankLines < (rightBlankLines = CodeEditUtil.getBlankLines(right.getText()));
            String text = leftBlankLines == 0 && rightBlankLines == 0 ? left.getText() + right.getText() : (leaveRightText ? right.getText() : left.getText());
            if (leaveRightText || forceReformat) {
                LeafElement merged = ASTFactory.whitespace(text);
                if (!leaveRightText) {
                    left.getTreeParent().replaceChild(left, merged);
                    right.getTreeParent().removeChild(right);
                } else {
                    right.getTreeParent().replaceChild(right, merged);
                    left.getTreeParent().removeChild(left);
                }
                left = merged;
            } else {
                right.getTreeParent().removeChild(right);
            }
        } else if (left.getElementType() != TokenType.WHITE_SPACE || forceReformat) {
            if (right.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(right);
            } else if (left.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(left);
            } else {
                CodeEditUtil.markToReformatBeforeOrInsertWhitespace(left, right);
            }
        }
        return left;
    }

    private static void markWhitespaceForReformat(ASTNode right) {
        String text = right.getText();
        LeafElement merged = ASTFactory.whitespace(text);
        right.getTreeParent().replaceChild(right, merged);
    }

    private static void markToReformatBeforeOrInsertWhitespace(ASTNode left, @NotNull ASTNode right) {
        if (right == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.markToReformatBeforeOrInsertWhitespace must not be null");
        }
        Language leftLang = left != null ? PsiUtilCore.getNotAnyLanguage(left) : null;
        Language rightLang = PsiUtilCore.getNotAnyLanguage(right);
        ASTNode generatedWhitespace = null;
        if (leftLang != null && leftLang.isKindOf(rightLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(leftLang)).generateWhitespaceBetweenTokens(left, right);
        } else if (rightLang.isKindOf(leftLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(rightLang)).generateWhitespaceBetweenTokens(left, right);
        }
        if (generatedWhitespace != null) {
            TreeUtil.CommonParentState parentState = new TreeUtil.CommonParentState();
            TreeUtil.prevLeaf((TreeElement)right, parentState);
            parentState.nextLeafBranchStart.getTreeParent().addChild(generatedWhitespace, parentState.nextLeafBranchStart);
        } else {
            CodeEditUtil.markToReformatBefore(right, true);
        }
    }

    public static void markToReformatBefore(ASTNode right, boolean value) {
        right.putCopyableUserData(REFORMAT_BEFORE_KEY, value ? Boolean.valueOf(true) : null);
    }

    private static int getBlankLines(String text) {
        int result = 0;
        int currentIndex = -1;
        while ((currentIndex = text.indexOf(10, currentIndex + 1)) >= 0) {
            ++result;
        }
        return result;
    }

    public static boolean isNodeGenerated(ASTNode node) {
        return node == null || node.getCopyableUserData(GENERATED_FLAG) != null;
    }

    public static void setNodeGenerated(ASTNode next, boolean value) {
        if (next == null) {
            return;
        }
        next.putCopyableUserData(GENERATED_FLAG, value ? Boolean.valueOf(true) : null);
    }

    public static void setOldIndentation(TreeElement treeElement, int oldIndentation) {
        if (treeElement == null) {
            return;
        }
        treeElement.putCopyableUserData(INDENT_INFO, oldIndentation >= 0 ? Integer.valueOf(oldIndentation) : null);
    }

    public static boolean isMarkedToReformatBefore(TreeElement element) {
        return element.getCopyableUserData(REFORMAT_BEFORE_KEY) != null;
    }

    @Nullable
    public static PsiElement createLineFeed(PsiManager manager) {
        return Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager).getPsi();
    }

    public static boolean isMarkedToReformat(ASTNode node) {
        return node.getCopyableUserData(REFORMAT_KEY) != null && CodeEditUtil.isSuspendedNodesReformattingAllowed();
    }

    public static void markToReformat(ASTNode node, boolean value) {
        if (ALLOW_TO_MARK_NODES_TO_REFORMAT.get().booleanValue()) {
            node.putCopyableUserData(REFORMAT_KEY, value ? Boolean.valueOf(true) : null);
        }
    }

    public static void disablePostponedFormatting(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.disablePostponedFormatting must not be null");
        }
        CodeEditUtil.markToReformat(node, false);
        CodeEditUtil.markToReformatBefore(node, false);
        node.putUserData(DISABLE_POSTPONED_REFORMAT_KEY, true);
    }

    public static void enablePostponedFormattingInTree(@NotNull ASTNode root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.enablePostponedFormattingInTree must not be null");
        }
        ((TreeElement)root).acceptTree(new RecursiveTreeElementVisitor(){

            @Override
            protected boolean visitNode(TreeElement element) {
                element.putUserData(DISABLE_POSTPONED_REFORMAT_KEY, null);
                return true;
            }
        });
    }

    public static boolean isPostponedFormattingDisabled(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.isPostponedFormattingDisabled must not be null");
        }
        return node.getUserData(DISABLE_POSTPONED_REFORMAT_KEY) != null;
    }

    public static void allowToMarkNodesForPostponedFormatting(boolean allow) {
        ALLOW_TO_MARK_NODES_TO_REFORMAT.set(allow);
    }

    public static boolean isSuspendedNodesReformattingAllowed() {
        return ALLOW_NODES_REFORMATTING.get();
    }

    public static void setAllowSuspendNodesReformatting(boolean allow) {
        ALLOW_NODES_REFORMATTING.set(allow);
    }
}

