/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.PlainTextFileType;
import org.jetbrains.jet.internal.com.intellij.openapi.fileTypes.PlainTextLanguage;
import org.jetbrains.jet.internal.com.intellij.psi.FileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PlainTextTokenTypes;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPlainTextFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReference;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;

public class PsiPlainTextFileImpl
extends PsiFileImpl
implements PsiPlainTextFile {
    private final FileType myFileType;

    public PsiPlainTextFileImpl(FileViewProvider viewProvider) {
        super(PlainTextTokenTypes.PLAIN_TEXT_FILE, PlainTextTokenTypes.PLAIN_TEXT_FILE, viewProvider);
        this.myFileType = viewProvider.getBaseLanguage() != PlainTextLanguage.INSTANCE ? PlainTextFileType.INSTANCE : viewProvider.getVirtualFile().getFileType();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiPlainTextFileImpl.accept must not be null");
        }
        visitor.visitPlainTextFile(this);
    }

    @Override
    public String toString() {
        return "PsiFile(plain text):" + this.getName();
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiPlainTextFileImpl.getFileType must not return null");
        }
        return fileType;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiPlainTextFile.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiPlainTextFileImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }
}

