/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Condition;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.JavaTokenType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.jet.internal.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.jet.internal.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.util.ArrayUtil;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectIntHashMap;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap<String, IElementType>();
    public static final TObjectIntHashMap<String> NAME_TO_MODIFIER_FLAG_MAP;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.hasModifierProperty must not be null");
        }
        PsiModifierListStub stub = (PsiModifierListStub)this.getStub();
        if (stub != null) {
            int flag = NAME_TO_MODIFIER_FLAG_MAP.get(name);
            assert (flag != 0);
            return (stub.getModifiersMask() & flag) != 0;
        }
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
            }
            if (((PsiClass)parent).isInterface()) {
                if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                    return true;
                }
                if (grandParent instanceof PsiClass && type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
            }
            if (((PsiClass)parent).isEnum()) {
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    if (!(grandParent instanceof PsiFile)) {
                        return true;
                    }
                } else {
                    if (type == JavaTokenType.FINAL_KEYWORD) {
                        PsiField[] fields;
                        for (PsiField field : fields = ((PsiClass)parent).getFields()) {
                            if (!(field instanceof PsiEnumConstant) || ((PsiEnumConstant)field).getInitializingClass() == null) continue;
                            return false;
                        }
                        return true;
                    }
                    if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                        PsiMethod[] methods;
                        for (PsiMethod method : methods = ((PsiClass)parent).getMethods()) {
                            if (!method.hasModifierProperty("abstract")) continue;
                            return true;
                        }
                        return false;
                    }
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                    return true;
                }
            }
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                return type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD;
            }
            PsiClass aClass = ((PsiField)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
                if (type == JavaTokenType.FINAL_KEYWORD) {
                    return true;
                }
            }
        } else if (parent instanceof PsiParameter ? type == JavaTokenType.FINAL_KEYWORD && ((PsiParameter)parent).getType() instanceof PsiDisjunctionType : parent instanceof PsiResourceVariable && type == JavaTokenType.FINAL_KEYWORD) {
            return true;
        }
        if (type == null) {
            return !this.hasModifierProperty("public") && !this.hasModifierProperty("private") && !this.hasModifierProperty("protected");
        }
        return this.getNode().findChildByType(type) != null;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        IElementType type;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.hasExplicitModifier must not be null");
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        return tree.findChildByType(type = NAME_TO_KEYWORD_TYPE_MAP.get(name)) != null;
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.setModifierProperty must not be null");
        }
        this.checkSetModifierProperty(name, value);
        PsiElement methodCandidate = this.getParent();
        if (methodCandidate instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)methodCandidate;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        }
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        CompositeElement parentTreeElement = treeElement.getTreeParent();
        if (value) {
            if (parentTreeElement.getElementType() == JavaElementType.FIELD && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(parentTreeElement.getTreeParent())).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD : (parentTreeElement.getElementType() == JavaElementType.METHOD && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(parentTreeElement.getTreeParent())).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD : (parentTreeElement.getElementType() == JavaElementType.CLASS && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(parentTreeElement.getTreeParent())).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD : parentTreeElement.getElementType() == JavaElementType.ANNOTATION_METHOD && parentTreeElement.getTreeParent().getElementType() == JavaElementType.CLASS && ((PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(parentTreeElement.getTreeParent())).isAnnotationType() && (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.PRIVATE_KEYWORD || type == JavaTokenType.PROTECTED_KEYWORD || type == null) {
                if (type != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type == null) {
                    return;
                }
            }
            if (treeElement.findChildByType(type) == null) {
                LeafElement keyword = Factory.createSingleLeafElement(type, name, null, this.getManager());
                treeElement.addInternal(keyword, keyword, null, null);
            }
            if ((type == JavaTokenType.ABSTRACT_KEYWORD || type == JavaTokenType.NATIVE_KEYWORD) && parentTreeElement.getElementType() == JavaElementType.METHOD) {
                // empty if block
            }
        } else {
            if (type == null) {
                throw new IncorrectOperationException("Cannot reset package local modifier.");
            }
            ASTNode child = treeElement.findChildByType(type);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull(child).delete();
            }
        }
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.checkSetModifierProperty must not be null");
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] own = (PsiAnnotation[])this.getStubOrPsiChildren(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List<PsiAnnotation> ext = PsiAugmentProvider.collectAugments(this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = ArrayUtil.mergeArrayAndCollection(own, ext, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiModifierListImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        final String[] fields = PsiAnnotationImpl.getApplicableElementTypeFields(this);
        List<PsiAnnotation> filtered = ContainerUtil.findAll(this.getAnnotations(), new Condition<PsiAnnotation>(){

            @Override
            public boolean value(PsiAnnotation annotation) {
                return PsiAnnotationImpl.isAnnotationApplicableTo(annotation, true, fields);
            }
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(new PsiAnnotation[filtered.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiModifierListImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.addAnnotation must not be null");
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter(JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createAnnotationFromText("@" + qualifiedName, this), null);
        if (psiAnnotation == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiModifierListImpl.addAnnotation must not return null");
        }
        return psiAnnotation;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiModifierListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();
        NAME_TO_MODIFIER_FLAG_MAP.put("public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put("protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put("private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put("packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put("static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put("abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put("final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put("native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put("synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put("strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put("transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put("volatile", 64);
    }
}

