/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.intellij.psi.impl.source;

import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.ui.Queryable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Computable;
import org.jetbrains.jet.internal.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiIdentifier;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethodReceiver;
import org.jetbrains.jet.internal.com.intellij.psi.PsiModifierList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiReferenceList;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.jet.internal.com.intellij.psi.ResolveState;
import org.jetbrains.jet.internal.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.jet.internal.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.jet.internal.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.jet.internal.com.intellij.psi.search.SearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignature;
import org.jetbrains.jet.internal.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.ui.RowIcon;
import org.jetbrains.jet.internal.com.intellij.util.IncorrectOperationException;
import org.jetbrains.jet.internal.com.intellij.util.PatchedSoftReference;
import org.jetbrains.jet.internal.com.intellij.util.PlatformIcons;

public class PsiMethodImpl
extends JavaStubPsiElement<PsiMethodStub>
implements Queryable,
PsiMethod {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiMethodImpl");
    private PatchedSoftReference<PsiType> myCachedType = null;

    public PsiMethodImpl(PsiMethodStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.METHOD);
    }

    protected PsiMethodImpl(PsiMethodStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    protected void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiMethodImpl clone = (PsiMethodImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @Override
    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public String getName() {
        PsiIdentifier nameIdentifier;
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        String name = stub != null ? stub.getName() : ((nameIdentifier = this.getNameIdentifier()) == null ? null : nameIdentifier.getText());
        String string = name != null ? name : "<unnamed>";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    @Override
    public PsiMethodReceiver getMethodReceiver() {
        ASTNode node = this.getNode().findChildByType(JavaElementType.METHOD_RECEIVER);
        if (node == null) {
            return null;
        }
        return (PsiMethodReceiver)node.getPsi();
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    public PsiType getReturnTypeNoResolve() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
            if (typeText == null) {
                return null;
            }
            try {
                return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createTypeFromText(typeText, this);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
                return null;
            }
        }
        PsiTypeElement typeElement = this.getReturnTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiParameterList parameterList = this.getParameterList();
        return JavaSharedImplUtil.getTypeNoResolve(typeElement, parameterList, this);
    }

    @Override
    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiType type;
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(true));
            if (typeText == null) {
                return null;
            }
            PatchedSoftReference<PsiType> cachedType = this.myCachedType;
            if (cachedType != null && (type = (PsiType)cachedType.get()) != null) {
                return type;
            }
            try {
                type = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createTypeFromText(typeText, this);
                this.myCachedType = new PatchedSoftReference<PsiType>(type);
                return type;
            }
            catch (IncorrectOperationException e) {
                LOG.error("stub: " + stub + "; method: " + this.getText(), e);
                return null;
            }
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getReturnTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiParameterList parameterList = this.getParameterList();
        return JavaSharedImplUtil.getType(typeElement, parameterList, this);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.PARAMETER_LIST);
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.THROWS_LIST);
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.getNode().findChildByRoleAsPsiElement(17);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getNode must not return null");
        }
        return compositeElement;
    }

    @Override
    public boolean isDeprecated() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(this);
        }
        return PsiImplUtil.isDeprecatedByDocTag(this) || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    @Override
    public boolean isConstructor() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getNode().findChildByRole(10) == null;
    }

    @Override
    public boolean isVarArgs() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isVarArgs();
        }
        return PsiImplUtil.isVarArgs(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.processDeclarations must not be null");
        }
        return PsiImplUtil.processDeclarationsInMethod(this, processor, state, lastParent, place);
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiClass originalClass = (PsiClass)this.getContainingClass().getOriginalElement();
        PsiMethod originalMethod = originalClass.findMethodBySignature(this, false);
        return originalMethod != null ? originalMethod : this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

            @Override
            public SearchScope compute() {
                return PsiImplUtil.getMemberUseScope(PsiMethodImpl.this);
            }
        });
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.putInfo must not be null");
        }
        info.put("methodName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

